/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.astah.dd.dc.Bounds;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.ActivityNodePresentation;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.ChoicePresentation;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.CombinedFragmentPresentation;
import net.astah.jmodel.ControlFlowPresentation;
import net.astah.jmodel.DeepHistoryPresentation;
import net.astah.jmodel.EntryPointPresentation;
import net.astah.jmodel.ExecutableNodePresentation;
import net.astah.jmodel.ExitPointPresentation;
import net.astah.jmodel.FinalStatePresentation;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.InitialStatePresentation;
import net.astah.jmodel.InstanceSpecificationPresentation;
import net.astah.jmodel.InteractionUsePresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.JunctionPointPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.LinePresentation;
import net.astah.jmodel.MMTopicPresentation;
import net.astah.jmodel.NotePresentation;
import net.astah.jmodel.ObjectFlowPresentation;
import net.astah.jmodel.ObjectNodePresentation;
import net.astah.jmodel.ObjectPresentation;
import net.astah.jmodel.PartPresentation;
import net.astah.jmodel.PathPresentation;
import net.astah.jmodel.PolyLinePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.RequirementPresentation;
import net.astah.jmodel.SequenceDestructionPresentation;
import net.astah.jmodel.SequenceMessageEndPresentation;
import net.astah.jmodel.SequenceMessagePresentation;
import net.astah.jmodel.ShallowHistoryPresentation;
import net.astah.jmodel.StateInvariantPresentation;
import net.astah.jmodel.StatePresentation;
import net.astah.jmodel.StateVertexPresentation;
import net.astah.jmodel.SwimlaneIndependable;
import net.astah.jmodel.TemplateBindingPresentation;
import net.astah.jmodel.TextPresentation;
import net.astah.jmodel.TransitionPresentation;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLSequenceDiagram;
import net.astah.jmodel.UseCasePresentation;
import net.astah.jmodel.impl.FramePresentationImpl;
import net.astah.jomt.jcontrol.SetEnclosingCombinedFragmentsCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.SequenceDiagramOperations;
import net.astah.notation.GraphicalShape;
import net.astah.notation.Shape;
import net.astah.notation.edit.command.Notations;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMShape;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MindMapUtilties;
import net.astah.uml2.operations.MessagePresentations;
import net.astah.uml2.uml.util.PartitionUtil;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.CombinedFragment;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.InteractionOperand;
import org.eclipse.uml2.uml.InteractionUse;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.NamedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizeCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(ResizeCommand.class);
    protected RectPresentation presentation = null;
    protected LinePresentation linePresentation = null;
    protected Shape shape = null;
    protected double width = 0.0;
    protected double height = 0.0;
    protected Pnt2d location = null;
    protected Pnt2d[] points = null;
    protected int spIndex = 0;
    protected int epIndex = 0;
    private Vec2d b;
    private List<Lifeline> c = new ArrayList<Lifeline>(0);
    private boolean d = false;

    public void setPresentation(DiagramElement diagramElement) {
        if (diagramElement instanceof RectPresentation) {
            this.presentation = (RectPresentation)diagramElement;
        } else if (diagramElement instanceof LinePresentation) {
            this.linePresentation = (LinePresentation)diagramElement;
        } else if (diagramElement instanceof MMShape) {
            this.shape = (MMShape)diagramElement;
        }
    }

    public void setSize(double d2, double d3) {
        this.width = d2;
        this.height = d3;
    }

    public void setPoints(Pnt2d[] pnt2dArray, int n2, int n3) {
        this.points = pnt2dArray;
        this.spIndex = n2;
        this.epIndex = n3;
    }

    public void setLocation(Pnt2d pnt2d) {
        this.location = pnt2d;
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (iJomtEntityStore == null) {
            return;
        }
        try {
            Object object;
            Object object2;
            if (this.presentation == null && this.linePresentation == null && this.shape == null && (object2 = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                object = ((DiagramEditor)object2).getSelectedPresentations();
                if (object == null || ((DiagramElement[])object).length != 1 || !(object[0] instanceof RectPresentation) && !(object[0] instanceof LinePresentation) && !(object[0] instanceof MMShape)) {
                    return;
                }
                if (object[0] instanceof RectPresentation) {
                    this.presentation = (RectPresentation)object[0];
                } else if (object[0] instanceof LinePresentation) {
                    this.linePresentation = (LinePresentation)object[0];
                } else if (object[0] instanceof MMShape) {
                    this.shape = (MMShape)object[0];
                }
            }
            if (this.linePresentation instanceof PolyLinePresentation ? this.width == 0.0 || this.height == 0.0 : !(this.presentation != null && this.width != 0.0 && this.height != 0.0 || this.shape != null && this.width != 0.0 && this.height != 0.0 || this.linePresentation != null && this.points.length != 0 || this.shape != null && this.points.length != 0)) {
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                object2 = this.a();
                if (this.presentation instanceof ActivityNodePresentation) {
                    this.a((ActivityNodePresentation)this.presentation);
                } else if (this.presentation instanceof StateVertexPresentation) {
                    this.a((StateVertexPresentation)this.presentation);
                } else if (this.presentation != null) {
                    if (this.presentation instanceof InteractionUsePresentation) {
                        object = ((InteractionUsePresentation)this.presentation).getInteractionUse();
                        object.getCovereds().clear();
                        object.getCovereds().addAll(this.c);
                    } else if (this.presentation instanceof CombinedFragmentPresentation) {
                        object = (CombinedFragmentPresentation)this.presentation;
                        if (this.b.y < 0.0 && object.getHeight() < this.height || this.b.y > 0.0 && object.getHeight() > this.height) {
                            for (int i2 = 0; i2 < object.getOperandOffsets().size(); ++i2) {
                                double d2 = object.getOperandOffset(i2 + 1);
                                object.setOperandOffset(i2 + 1, d2 - this.b.y);
                            }
                        }
                        object.setSize(this.width, this.height);
                    } else if (this.presentation instanceof StateInvariantPresentation) {
                        this.presentation.setSize(this.width, this.height);
                        object = (StateInvariantPresentation)this.presentation;
                        object.resize();
                    } else if (this.presentation instanceof LabelPresentation && (((LabelPresentation)this.presentation).getCompositeParent() instanceof TransitionPresentation || ((LabelPresentation)this.presentation).getCompositeParent() instanceof ControlFlowPresentation || ((LabelPresentation)this.presentation).getCompositeParent() instanceof ObjectFlowPresentation || ((LabelPresentation)this.presentation).getCompositeParent() instanceof TemplateBindingPresentation)) {
                        object = (LabelPresentation)this.presentation;
                        object.setDoAutoResize(false);
                        Vec2d vec2d = object.getLocalMovement();
                        object.setLocalMovement(new Vec2d(vec2d.x + this.b.x / 2.0, vec2d.y + this.b.y / 2.0));
                        this.presentation.setSize(this.width, this.height);
                        PathPresentation pathPresentation = (PathPresentation)object.getCompositeParent();
                        pathPresentation.updateNamePresentation();
                        if (((LabelPresentation)this.presentation).getCompositeParent() instanceof TemplateBindingPresentation) {
                            ((TemplateBindingPresentation)((LabelPresentation)this.presentation).getCompositeParent()).updateBoundInfoPresentation();
                        }
                    } else {
                        this.presentation.setSize(this.width, this.height);
                    }
                } else if (this.shape != null) {
                    if (this.points != null && this.points.length > 0) {
                        Notations.setPoints(this.shape, Stream.of(this.points).map(Geometries::toPoint).collect(Collectors.toList()));
                    } else {
                        Notations.setSize(this.shape, MindMapUtilties.getResizeDimension((MMShape)this.shape, this.width, this.height));
                    }
                }
                if (this.location != null) {
                    if (this.shape != null) {
                        if (this.shape instanceof MMTopicShape && !((MMTopicShape)this.shape).isRoot() || this.shape instanceof GraphicalShape) {
                            Notations.setLocation(this.shape, this.location.getX(), this.location.getY());
                        }
                    } else if (!(this.presentation != null && this.presentation instanceof LabelPresentation && (((LabelPresentation)this.presentation).getCompositeParent() instanceof TransitionPresentation || ((LabelPresentation)this.presentation).getCompositeParent() instanceof ControlFlowPresentation || ((LabelPresentation)this.presentation).getCompositeParent() instanceof ObjectFlowPresentation || ((LabelPresentation)this.presentation).getCompositeParent() instanceof TemplateBindingPresentation) || this.presentation == null)) {
                        this.presentation.setLocation(this.location);
                    }
                }
                if (this.presentation instanceof LabelPresentation) {
                    ((LabelPresentation)this.presentation).setDoAutoResize(false);
                    if (this.presentation instanceof CombinedFragmentPresentation) {
                        this.a((LabelPresentation)((CombinedFragmentPresentation)this.presentation));
                        this.a((CombinedFragmentPresentation)this.presentation);
                    } else if (this.presentation instanceof InteractionUsePresentation) {
                        this.a((InteractionUsePresentation)this.presentation);
                        this.presentation.setSize(this.width, this.height);
                        ((InteractionUsePresentation)this.presentation).updateGatesHorizontally(this.b.x);
                    } else if (this.presentation instanceof FramePresentation) {
                        if (this.b != null) {
                            ((FramePresentationImpl)this.presentation).updateGatesHorizontally(this.b.x);
                        }
                        ((FramePresentation)this.presentation).adjustAttachedClients((Rectangle2d)object2, this.presentation.getBoundsRect());
                    }
                }
                if (this.presentation instanceof SequenceMessageEndPresentation) {
                    ((SequenceMessageEndPresentation)this.presentation).resize();
                } else if (this.presentation instanceof SequenceDestructionPresentation) {
                    ((SequenceDestructionPresentation)this.presentation).adjustLifeline();
                } else if (this.presentation instanceof ClassifierPresentation) {
                    if (this.presentation instanceof RequirementPresentation) {
                        ((LabelPresentation)this.presentation).resize();
                    } else {
                        ((ClassifierPresentation)this.presentation).adjustAttachedClients((Rectangle2d)object2, this.presentation.getBoundsRect());
                        this.callResizeIfSpecialClass((ClassifierPresentation)this.presentation);
                    }
                } else if (this.presentation instanceof PartPresentation) {
                    ((PartPresentation)this.presentation).adjustAttachedClients((Rectangle2d)object2, this.presentation.getBoundsRect());
                    ((LabelPresentation)this.presentation).resize();
                } else if (this.presentation instanceof ExecutableNodePresentation) {
                    ((LabelPresentation)this.presentation).adjustAttachedClients((Rectangle2d)object2, this.presentation.getBoundsRect());
                    ((LabelPresentation)this.presentation).resize();
                } else if (this.presentation instanceof StatePresentation) {
                    ((StatePresentation)this.presentation).adjustAttachedClients((Rectangle2d)object2, this.presentation.getBoundsRect());
                    ((StatePresentation)this.presentation).resize();
                } else if (this.presentation instanceof NotePresentation || this.presentation instanceof UseCasePresentation || this.presentation instanceof InstanceSpecificationPresentation || this.presentation instanceof TextPresentation && !(this.presentation instanceof MMTopicPresentation) || this.presentation instanceof ObjectPresentation || this.presentation instanceof ObjectNodePresentation) {
                    ((LabelPresentation)this.presentation).resize();
                } else {
                    this.callResizeIfSpecialPresentation(this.presentation);
                }
                if (this.b() instanceof UMLSequenceDiagram) {
                    this.c();
                }
                if (this.linePresentation instanceof PolyLinePresentation) {
                    ((PolyLinePresentation)this.linePresentation).setBoundRect(this.location.x, this.location.y, this.width, this.height);
                } else if (this.linePresentation != null) {
                    this.linePresentation.reSize(this.points[this.spIndex], this.points[this.epIndex]);
                }
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                a.error("error has occurred", badTransactionException);
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                this.d = true;
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            a.error("error has occurred", exception);
            MessageManager.requireBugReport(exception);
        }
    }

    private Rectangle2d a() {
        Bounds bounds;
        if (this.presentation != null) {
            return this.presentation.getBoundsRect();
        }
        if (this.shape != null && (bounds = new LayoutCalculator().getBounds(this.shape)) != null) {
            return Geometries.toRectangle2d(bounds);
        }
        return null;
    }

    private void a(StateVertexPresentation stateVertexPresentation) {
        if (stateVertexPresentation instanceof InitialStatePresentation || stateVertexPresentation instanceof FinalStatePresentation || stateVertexPresentation instanceof ShallowHistoryPresentation || stateVertexPresentation instanceof DeepHistoryPresentation || stateVertexPresentation instanceof JunctionPointPresentation || stateVertexPresentation instanceof ChoicePresentation) {
            double d2 = 0.0;
            d2 = this.width > this.height ? this.height : this.width;
            stateVertexPresentation.setSize(d2, d2, false);
        } else if (!(stateVertexPresentation instanceof EntryPointPresentation) && !(stateVertexPresentation instanceof ExitPointPresentation)) {
            StatePresentation statePresentation;
            if (stateVertexPresentation instanceof StatePresentation && (statePresentation = (StatePresentation)stateVertexPresentation).getState().isOrthogonal()) {
                if (statePresentation.getHorizontalRegionSize() > 1) {
                    Double[] doubleArray = statePresentation.getHorizontalRegionOffsets().toArray(new Double[0]);
                    Double[] doubleArray2 = new Double[doubleArray.length];
                    System.arraycopy(doubleArray, 0, doubleArray2, 0, doubleArray.length);
                    if (this.a((RectPresentation)statePresentation)) {
                        int n2 = 0;
                        while (n2 < doubleArray2.length) {
                            Double[] doubleArray3 = doubleArray2;
                            int n3 = n2++;
                            Double.valueOf(doubleArray3[n3] + (this.height - stateVertexPresentation.getHeight()));
                        }
                        statePresentation.getHorizontalRegionOffsets().clear();
                        statePresentation.getHorizontalRegionOffsets().addAll(Arrays.asList(doubleArray2));
                    }
                } else if (statePresentation.getVerticalRegionSize() > 1) {
                    Double[] doubleArray = statePresentation.getVerticalRegionOffsets().toArray(new Double[0]);
                    Double[] doubleArray4 = new Double[doubleArray.length];
                    System.arraycopy(doubleArray, 0, doubleArray4, 0, doubleArray.length);
                    if (this.b(statePresentation)) {
                        int n4 = 0;
                        while (n4 < doubleArray4.length) {
                            Double[] doubleArray5 = doubleArray4;
                            int n5 = n4++;
                            Double.valueOf(doubleArray5[n5] + (this.width - stateVertexPresentation.getWidth()));
                        }
                        statePresentation.getVerticalRegionOffsets().clear();
                        statePresentation.getVerticalRegionOffsets().addAll(Arrays.asList(doubleArray4));
                    }
                }
            }
            stateVertexPresentation.setSize(this.width, this.height, false);
        }
    }

    private void a(ActivityNodePresentation activityNodePresentation) {
        double d2;
        double d3;
        double d4;
        double d5;
        ActivityPartitionPresentation activityPartitionPresentation;
        UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)activityNodePresentation.getDiagram();
        ActivityPartition activityPartition = PartitionUtil.getMyPartition(uMLActivityDiagram, activityNodePresentation.getModel(), false);
        ActivityPartition activityPartition2 = PartitionUtil.getMyPartition(uMLActivityDiagram, activityNodePresentation.getModel(), true);
        Pnt2d pnt2d = null;
        pnt2d = this.location == null ? activityNodePresentation.getLocation() : this.location;
        if (activityPartition != null) {
            activityPartitionPresentation = (ActivityPartitionPresentation)Presentations.getPresentation(activityPartition);
            d5 = activityPartitionPresentation.getMaxX();
            d4 = pnt2d.x + this.width;
            d3 = activityPartitionPresentation.getMaxY();
            d2 = pnt2d.y + this.height;
            if (!(!(d4 > d5) && !(d2 > d3) || activityNodePresentation instanceof SwimlaneIndependable && ((SwimlaneIndependable)((Object)activityNodePresentation)).isSwimlaneIndependent())) {
                activityNodePresentation.setLocation(pnt2d);
                activityNodePresentation.setSize(this.width, this.height, true);
                activityPartitionPresentation.resize();
            } else {
                activityNodePresentation.setSize(this.width, this.height, false);
            }
        }
        if (activityPartition2 != null) {
            activityPartitionPresentation = (ActivityPartitionPresentation)Presentations.getPresentation(activityPartition2);
            d5 = activityPartitionPresentation.getMaxX();
            d4 = pnt2d.x + this.width;
            d3 = activityPartitionPresentation.getMaxY();
            d2 = pnt2d.y + this.height;
            if (!(!(d4 > d5) && !(d2 > d3) || activityNodePresentation instanceof SwimlaneIndependable && ((SwimlaneIndependable)((Object)activityNodePresentation)).isSwimlaneIndependent())) {
                activityNodePresentation.setSize(this.width, this.height, true);
                activityPartitionPresentation.resize();
            } else {
                activityNodePresentation.setSize(this.width, this.height, false);
            }
        }
        if (activityPartition == null && activityPartition2 == null) {
            activityNodePresentation.setSize(this.width, this.height, false);
        }
    }

    protected void callResizeIfSpecialClass(ClassifierPresentation classifierPresentation) {
    }

    protected void callResizeIfSpecialPresentation(RectPresentation rectPresentation) {
    }

    private boolean a(RectPresentation rectPresentation) {
        return this.location != null && (this.location.y < rectPresentation.getMinY() && this.height > rectPresentation.getHeight() || this.location.y > rectPresentation.getMinY() && this.height < rectPresentation.getHeight());
    }

    private boolean b(RectPresentation rectPresentation) {
        return this.location != null && (this.location.x < rectPresentation.getMinX() && this.width > rectPresentation.getWidth() || this.location.x > rectPresentation.getMinX() && this.width < rectPresentation.getWidth());
    }

    private void a(LabelPresentation labelPresentation) {
        CombinedFragmentPresentation combinedFragmentPresentation = null;
        InteractionOperand interactionOperand = null;
        if (labelPresentation instanceof InteractionUsePresentation) {
            combinedFragmentPresentation = ((InteractionUsePresentation)labelPresentation).getParentCombinedFragment();
            interactionOperand = ((InteractionUse)labelPresentation.getModel()).getEnclosingOperand();
        } else if (labelPresentation instanceof CombinedFragmentPresentation) {
            combinedFragmentPresentation = ((CombinedFragmentPresentation)labelPresentation).getParentCombinedFragment();
            interactionOperand = ((CombinedFragment)labelPresentation.getModel()).getEnclosingOperand();
        }
        SetEnclosingCombinedFragmentsCommand setEnclosingCombinedFragmentsCommand = new SetEnclosingCombinedFragmentsCommand();
        setEnclosingCombinedFragmentsCommand.setChildFragment((InteractionFragment)labelPresentation.getModel());
        if (combinedFragmentPresentation != null) {
            setEnclosingCombinedFragmentsCommand.setEnclosingOperand(interactionOperand);
            setEnclosingCombinedFragmentsCommand.setParentCombinedFragment(combinedFragmentPresentation);
        }
        this.callCommand(setEnclosingCombinedFragmentsCommand);
    }

    private void a(CombinedFragmentPresentation combinedFragmentPresentation) {
        CombinedFragment combinedFragment = (CombinedFragment)combinedFragmentPresentation.getModel();
        combinedFragment.getCovereds().clear();
        Interaction interaction = ((UMLSequenceDiagram)this.b()).getInteraction();
        for (InteractionOperand eModelElement : combinedFragment.getOperands()) {
            interaction.getFragments().addAll(eModelElement.getFragments());
        }
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            NamedElement namedElement;
            Presentation presentation = (Presentation)((Object)this.c.get(i2));
            InteractionOperand interactionOperand = this.a(combinedFragmentPresentation, presentation);
            if (presentation instanceof SequenceMessagePresentation) {
                namedElement = (Message)presentation.getModel();
                interactionOperand.getFragments().addAll(MessagePresentations.getRelatedFragments((Message)namedElement));
                continue;
            }
            if (presentation.getModel() instanceof InteractionFragment) {
                namedElement = (InteractionFragment)presentation.getModel();
                namedElement.setEnclosingOperand(interactionOperand);
                continue;
            }
            if (!(presentation instanceof LifelinePresentation)) continue;
            namedElement = (Lifeline)presentation.getModel();
            combinedFragment.getCovereds().add((Lifeline)namedElement);
        }
    }

    private InteractionOperand a(CombinedFragmentPresentation combinedFragmentPresentation, Presentation presentation) {
        JomtPresentation jomtPresentation;
        Pnt2d pnt2d = combinedFragmentPresentation.getLocation();
        int n2 = 0;
        double d2 = 0.0;
        if (presentation instanceof SequenceMessagePresentation) {
            jomtPresentation = (SequenceMessagePresentation)presentation;
            Pnt2d[] pnt2dArray = jomtPresentation.getPointsForJudge();
            d2 = pnt2dArray[0].y;
        } else if (presentation.getModel() instanceof InteractionFragment) {
            jomtPresentation = (LabelPresentation)presentation;
            d2 = jomtPresentation.getLocation().y;
        }
        for (int i2 = 0; i2 < combinedFragmentPresentation.getOperandOffsets().size(); ++i2) {
            double d3 = combinedFragmentPresentation.getOperandOffset(i2 + 1);
            double d4 = combinedFragmentPresentation.getOperandOffset(i2 + 2);
            if (!(d2 > pnt2d.y + d3) || d4 != 0.0 && !(d2 < pnt2d.y + d4)) continue;
            n2 = i2 + 1;
            break;
        }
        CombinedFragment combinedFragment = (CombinedFragment)combinedFragmentPresentation.getModel();
        return (InteractionOperand)combinedFragment.getOperands().get(n2);
    }

    private Diagram b() {
        Object object;
        if (this.presentation != null) {
            object = this.presentation.getDiagram();
            if (object != null) {
                return object;
            }
        } else if (this.shape != null && (object = this.shape.getOwningElement()) != null && object instanceof MMDiagram) {
            return (MMDiagram)object;
        }
        if (JomtGlobal.viewManager != null) {
            object = JomtGlobal.viewManager.getCurrentDiagramEditor();
            return object != null ? ((DiagramEditor)object).getDiagram() : null;
        }
        return null;
    }

    private void c() {
        SequenceDiagramOperations.setAllMessageIndex((UMLSequenceDiagram)this.b());
    }

    public void setResizeVec(Vec2d vec2d) {
        this.b = vec2d;
    }

    public void setChildren(List<Lifeline> list) {
        this.c = list;
    }

    public boolean isBadTransactionException() {
        return this.d;
    }
}

