/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.ActivityPartitionPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml2.uml.util.PartitionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResizeActivityPartitionCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(ResizeActivityPartitionCommand.class);
    private ActivityPartitionPresentation b = null;
    protected double width = 0.0;
    protected double height = 0.0;
    protected Pnt2d location = null;
    protected Vec2d vec = null;

    public void setPresentation(ActivityPartitionPresentation activityPartitionPresentation) {
        this.b = activityPartitionPresentation;
    }

    public void setSize(double d2, double d3) {
        this.width = d2;
        this.height = d3;
    }

    public void setLocation(Pnt2d pnt2d) {
        this.location = pnt2d;
    }

    public void setResizeVector(Vec2d vec2d) {
        this.vec = vec2d;
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (iJomtEntityStore == null) {
            return;
        }
        try {
            Object object;
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (this.b == null && diagramEditor != null) {
                object = diagramEditor.getSelectedPresentations();
                if (((DiagramElement[])object).length != 1 || !(object[0] instanceof RectPresentation)) {
                    return;
                }
                this.b = (ActivityPartitionPresentation)object[0];
            }
            if (diagramEditor == null) {
                return;
            }
            object = (UMLActivityDiagram)diagramEditor.getDiagram();
            if (this.b == null || this.width == 0.0 || this.height == 0.0) {
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                this.b.setSize(this.width, this.height);
                if (this.location != null) {
                    this.b.setLocation(this.location);
                }
                PartitionUtil.alignLengthOfSwimlanes((UMLActivityDiagram)object, this.b);
                this.b.resize();
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                a.error("error has occurred", badTransactionException);
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            a.error("error has occurred", exception);
            MessageManager.requireBugReport(exception);
        }
    }
}

