/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Function;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.control.Command;
import net.astah.jomt.jcontrol.U;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.project.Project;
import net.astah.project.ProjectManagerAdapter;
import net.astah.uml2.uml.EcoreUMLIDGenerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class ResetAllModelIDCommand
extends Command {
    private boolean a = true;

    @Override
    public void setArgumentString(String string) {
        if (string != null && string.equalsIgnoreCase("false")) {
            this.a = false;
        }
    }

    @Override
    public void execute() {
        int n2;
        if (this.a && (n2 = MessageManager.displayMessageOKDialog("app", "ask_reset_id.message")) != 0) {
            return;
        }
        net.astah.jmodel.Project project = ModelGlobal.prjManager.getCurrentProject();
        if (project == null) {
            return;
        }
        EditingDomain editingDomain = project.doc.getDomain();
        ProjectManagerAdapter projectManagerAdapter = ProjectManagerAdapter.getProjectManagerAdapter(editingDomain.getResourceSet());
        Project project2 = projectManagerAdapter.getRootProject();
        if (project2 == null) {
            return;
        }
        TransactionalEditingDomain transactionalEditingDomain = (TransactionalEditingDomain)editingDomain;
        new CommandJob(transactionalEditingDomain, new U(this, transactionalEditingDomain, editingDomain, project2, projectManagerAdapter)).schedule();
    }

    protected void resolveProject(EditingDomain editingDomain, Project project) {
        if (!project.isReadonly()) {
            for (Resource resource : project.getResources()) {
                if (editingDomain.isReadOnly(resource)) continue;
                this.resolveResource(resource);
            }
            this.resolveResource(project.eResource());
        }
    }

    protected void resolveResource(Resource resource) {
        TreeIterator treeIterator = EcoreUtil.getAllProperContents(resource, true);
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            this.resolveEObject(eObject);
        }
    }

    protected void resolveEObject(EObject eObject) {
        Iterator iterator = eObject.eCrossReferences().iterator();
        if (iterator instanceof EContentsEList.Filterable) {
            ((EContentsEList.Filterable)((Object)iterator)).filter(eStructuralFeature -> !eStructuralFeature.isDerived());
        }
        Iterators.size(iterator);
    }

    protected void processResources(EditingDomain editingDomain, ProjectManagerAdapter projectManagerAdapter, Function<EObject, String> function) {
        LinkedHashSet<Project> linkedHashSet = new LinkedHashSet<Project>();
        for (Resource notifier : Lists.newArrayList(editingDomain.getResourceSet().getResources())) {
            Project project = projectManagerAdapter.getContainingProject(notifier);
            if (project == null || project.isReadonly()) continue;
            this.processResource(notifier, function);
            linkedHashSet.add(project);
        }
        for (Project project : linkedHashSet) {
            this.processProjectResource(project, function);
        }
    }

    protected void processProjectResource(Project project, Function<EObject, String> function) {
        String string;
        Resource resource = project.eResource();
        URI uRI = project.getVirtualURI().appendSegment("");
        this.processResource(resource, function);
        if (resource instanceof XMLResource && (string = ((XMLResource)resource).getID(project)) != null && !string.equals(project.getId())) {
            String[] stringArray = new String[]{string, ""};
            URI uRI2 = uRI.trimSegments(2).appendSegments(stringArray);
            for (Resource resource2 : project.getResources()) {
                URI uRI3 = resource2.getURI().replacePrefix(uRI, uRI2);
                resource2.setURI(uRI3);
            }
            project.setId(string);
        }
    }

    protected void processResource(Resource resource, Function<EObject, String> function) {
        if (resource instanceof XMLResource) {
            XMLResource xMLResource = (XMLResource)resource;
            TreeIterator treeIterator = EcoreUtil.getAllProperContents(resource, true);
            boolean bl = false;
            while (treeIterator.hasNext()) {
                String string;
                EObject eObject = (EObject)treeIterator.next();
                if (xMLResource.getID(eObject) == null || (string = function.apply(eObject)) == null) continue;
                xMLResource.setID(eObject, string);
                bl = true;
            }
            if (bl) {
                resource.setModified(true);
            }
        }
    }

    @Deprecated
    Project a(EditingDomain editingDomain, ProjectManagerAdapter projectManagerAdapter, URI uRI) {
        Project project = projectManagerAdapter.getRootProject();
        for (Project project2 : project.getNestedProjects()) {
            if (!Objects.equals(project2.eResource().getURI(), uRI)) continue;
            return project2;
        }
        try {
            Project project3 = projectManagerAdapter.open(uRI);
            project3.load(null);
            project3.setNestingProject(project);
            projectManagerAdapter.addListener(notification -> {
                if (!notification.isTouch() && notification.getNotifier() == project && notification.getFeatureID(Project.class) == 14 && !notification.getNewBooleanValue()) {
                    try {
                        project3.save(Collections.singletonMap("SAVE_UNMODIFIED", true));
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            });
            return project3;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    protected Function<EObject, String> createGenerator() {
        return new EcoreUMLIDGenerator(true, "http://www.omg.org/", "http://www.eclipse.org/");
    }
}

