/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.DiagramElement;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.notation.mindmap.MMTopicShape;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;

public class RemoveMMImageCommand
extends Command {
    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            Object[] objectArray = diagramEditor.getSelectedModels();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            boolean bl = false;
            try {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    MMTopicShape mMTopicShape;
                    DiagramElement diagramElement = DiagramElementOperations.getDiagramElement(objectArray[i2]);
                    if (!(diagramElement instanceof MMTopicShape) || (mMTopicShape = (MMTopicShape)diagramElement).getImage() == null) continue;
                    if (!bl) {
                        bl = true;
                        iJomtEntityStore.beginTransaction();
                    }
                    EditingDomain editingDomain = iJomtEntityStore.getDomain();
                    CommandUtils.execute(editingDomain, RemoveCommand.create(editingDomain, mMTopicShape.getImage()));
                }
                if (bl) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }
}

