/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.DiagramElement;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.MiniIconUtil;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.notation.mindmap.MMDiagramElement;
import net.astah.notation.mindmap.MMGraphicalShape;
import net.astah.notation.mindmap.MMImage;
import net.astah.notation.mindmap.MMTopicShape;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;

public class RemoveMMIconCommand
extends Command {
    private int a = -1;

    @Override
    public void setArgumentString(String string) {
        if (string != null) {
            this.a = Integer.parseInt(string);
        }
    }

    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            Object[] objectArray = diagramEditor.getSelectedModels();
            if (objectArray == null || objectArray.length == 0) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    DiagramElement diagramElement;
                    DiagramElement diagramElement2 = DiagramElementOperations.getDiagramElement(objectArray[i2]);
                    if (diagramElement2 instanceof MMDiagramElement) {
                        if (diagramElement2 instanceof MMTopicShape) {
                            diagramElement = (MMTopicShape)diagramElement2;
                            if (diagramElement.getIcons().isEmpty()) continue;
                            this.a(iJomtEntityStore, diagramElement.getIcons());
                            continue;
                        }
                        if (!(diagramElement2 instanceof MMGraphicalShape) || (diagramElement = (MMGraphicalShape)diagramElement2).getIcons().isEmpty()) continue;
                        this.a(iJomtEntityStore, diagramElement.getIcons());
                        continue;
                    }
                    if (!MiniIconUtil.isMiniIconTarget((Presentation)diagramElement2) || (diagramElement = (Presentation)diagramElement2).getMiniIcons() == null || diagramElement.getMiniIcons().isEmpty()) continue;
                    if (this.a != -1) {
                        RemoveMMIconCommand.a(iJomtEntityStore, this.a, (Presentation)diagramElement);
                        continue;
                    }
                    for (int i3 = diagramElement.getMiniIcons().size() - 1; i3 >= 0; --i3) {
                        RemoveMMIconCommand.a(iJomtEntityStore, i3, (Presentation)diagramElement);
                    }
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                MessageManager.requireBugReport(exception);
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private void a(IEntityStore iEntityStore, EList<MMImage> eList) throws InterruptedException, RollbackException {
        if (this.a != -1) {
            RemoveMMIconCommand.a(iEntityStore, (MMImage)eList.get(this.a));
        } else {
            RemoveMMIconCommand.removeAllMMIcons(eList, iEntityStore);
        }
    }

    public static void removeAllMMIcons(EList<MMImage> eList, IEntityStore iEntityStore) throws InterruptedException, RollbackException {
        if (eList == null) {
            return;
        }
        EditingDomain editingDomain = iEntityStore.getDomain();
        CommandUtils.execute(editingDomain, RemoveCommand.create(editingDomain, eList));
    }

    private static void a(IEntityStore iEntityStore, MMImage mMImage) throws InterruptedException, RollbackException {
        EditingDomain editingDomain = iEntityStore.getDomain();
        CommandUtils.execute(editingDomain, RemoveCommand.create(editingDomain, mMImage));
    }

    private static void a(IEntityStore iEntityStore, int n2, Presentation presentation) {
        String string = presentation.getMiniIconIDFromIndex(n2);
        presentation.removeMiniIconFromIndex(n2);
    }
}

