/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.StatePresentation;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import org.eclipse.uml2.uml.State;

public abstract class RemoveActionFromStateCommand
extends Command {
    protected State state;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        try {
            if (this.state == null) {
                DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
                Object[] objectArray = diagramEditor.getSelectedModels();
                if (objectArray == null || objectArray.length == 0) {
                    return;
                }
                if (!(objectArray[0] instanceof UserObject)) {
                    return;
                }
                Presentation presentation = ((UserObject)objectArray[0]).getPresentation();
                if (!(presentation instanceof StatePresentation)) {
                    return;
                }
                this.state = (State)((StatePresentation)presentation).getModel();
            }
            if (!this.isExistedAction()) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                this.removeAction();
                iJomtEntityStore.commitTransaction();
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                iJomtEntityStore.abortTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected abstract void removeAction();

    protected abstract boolean isExistedAction();

    public void setState(State state) {
        this.state = state;
    }
}

