/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.List;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GNode;
import net.astah.golf.util.Debug;
import net.astah.jmodel.Project;
import net.astah.jmodel.impl.BinaryRelationPresentationImpl;
import net.astah.jmodel.impl.FramePresentationImpl;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.ViewGlobal;
import net.astah.jomt.jutil.JomtFontUtilities;
import net.astah.jomt.jutil.JomtPresentationUtil;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.CModelPane;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import net.astah.jomt.jviewElement.DiagramViewElement;
import net.astah.jomt.jviewElement.JomtDiagramViewElement;
import net.astah.uml.mindmap.MMUserIconManager;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedoCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(RedoCommand.class);

    @Override
    public void execute() {
        JomtGlobal.commandSupport.startWaitCursor();
        try {
            Editor editor;
            Project project = ModelGlobal.prjManager.getCurrentProject();
            DiagramViewElement diagramViewElement = null;
            List<GNode> list = null;
            if (!JomtGlobal.isNoGUI() && (editor = JomtGlobal.viewManager.getCurrentEditor()) != null) {
                if (editor instanceof DiagramEditor) {
                    list = ((DiagramEditor)editor).getCanvas().getSelectedNodes();
                    ((DiagramEditor)editor).getCanvas().unselect();
                    ((DiagramEditor)editor).getCanvasUIView().popMode();
                    JomtGlobal.modeManager.changeButtonsState(false);
                    diagramViewElement = ((DiagramEditor)editor).getDiagramScene().getDiagramViewElement();
                } else {
                    editor.unselect();
                }
            }
            if (project == null) {
                JomtGlobal.commandSupport.endWaitCursor();
                Debug.impossible("RedoCommand#execute(): current project = null.");
                return;
            }
            if (project.canRedo()) {
                EObject eObject;
                DiagramEditor diagramEditor;
                boolean bl = false;
                if (diagramViewElement != null && diagramViewElement instanceof JomtDiagramViewElement) {
                    bl = diagramViewElement.getCreateEditState();
                    diagramViewElement.setCreateEditState(false);
                }
                EObject eObject2 = this.b();
                project.doc.beginTransaction();
                FramePresentationImpl.NEED_UPDATED = false;
                BinaryRelationPresentationImpl.setSuppressUpdate(true);
                project.redo();
                BinaryRelationPresentationImpl.setSuppressUpdate(false);
                FramePresentationImpl.NEED_UPDATED = true;
                JomtFontUtilities.resetProjectFont();
                MMUserIconManager.instance().initializeProjectUserIconInfo(project.doc);
                project.doc.commitTransaction();
                if (diagramViewElement != null) {
                    diagramViewElement.setCreateEditState(bl);
                }
                if ((diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null && list != null) {
                    diagramEditor.getCanvas().select(list);
                }
                if ((eObject = this.b()) == eObject2) {
                    JomtGlobal.viewManager.updatePropertyView(eObject);
                }
                SwingInvoker.runLaterInEDT(() -> this.a());
            }
            JomtPresentationUtil.validateClipboard(ViewGlobal.clipboard, project.doc);
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
        JomtGlobal.commandSupport.endWaitCursor();
    }

    private void a() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (diagramEditor != null) {
            diagramEditor.repaintCanvas();
            diagramEditor.setNeedInitializeSearchToolBar(true);
        }
    }

    private EObject b() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        if (propertyView == null) {
            return null;
        }
        CModelPane cModelPane = propertyView.getModelPane();
        if (cModelPane == null) {
            return null;
        }
        ModelTabGroup modelTabGroup = cModelPane.getCurrentModelTabGroup();
        if (modelTabGroup == null) {
            return null;
        }
        return modelTabGroup.getModelElement();
    }
}

