/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.DiagramElement;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMTopicSymmetryRelocater;
import org.eclipse.emf.common.util.EList;

public class ReLayoutCommand
extends Command {
    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            DiagramElement[] diagramElementArray = diagramEditor.getSelectedPresentations();
            if (diagramElementArray == null || diagramElementArray.length == 0 || !(diagramElementArray[0] instanceof MMTopicShape)) {
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                MMDiagram mMDiagram = (MMDiagram)diagramEditor.getDiagram();
                this.a((MMTopicShape)diagramElementArray[0]);
                new MMTopicSymmetryRelocater(mMDiagram).startLayout();
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private void a(MMTopicShape mMTopicShape) {
        mMTopicShape.setManualLayout(false);
        EList<MMTopicShape> eList = mMTopicShape.allChildren();
        for (MMTopicShape mMTopicShape2 : eList) {
            mMTopicShape2.setManualLayout(false);
        }
    }
}

