/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.print.PrinterJob;
import net.astah.dd.di.Diagram;
import net.astah.golf.control.Command;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jcontrol.CommandSupport;
import net.astah.jomt.jcontrol.OpenDiagramEditorFromPrjCommand;
import net.astah.jomt.jcontrol.OpenTableEditorCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PrintConfigDialog;
import net.astah.notation.TableView;

public class PrintConfigCommand
extends Command {
    private boolean a = false;
    private boolean b = false;

    @Override
    public void setArgumentString(String string) {
        if (string.startsWith("dgm")) {
            this.a = true;
        }
        if (string.endsWith("pop")) {
            this.b = true;
        }
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            Object object;
            Frame frame = (Frame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
            if (PrinterJob.getPrinterJob().getPrintService() == null) {
                MessageManager.displayInfoMessageDialog("app", "system_no_printer.message");
                return;
            }
            if (this.b && (object = CommandSupport.instance().getSelectedUserObjectFromProjectView()) != null) {
                Diagram diagram = (Diagram)object;
                if (diagram instanceof TableView) {
                    OpenTableEditorCommand openTableEditorCommand = new OpenTableEditorCommand();
                    openTableEditorCommand.setElement(diagram);
                    this.callCommand(openTableEditorCommand);
                } else {
                    OpenDiagramEditorFromPrjCommand openDiagramEditorFromPrjCommand = new OpenDiagramEditorFromPrjCommand();
                    this.callCommand(openDiagramEditorFromPrjCommand);
                }
            }
            PrintConfigDialog.setPrintDgm(this.a);
            object = PrintConfigDialog.getInstance(frame);
            iJomtEntityStore.beginTransaction();
            ((Dialog)object).setVisible(true);
            if (((PrintConfigDialog)object).getResultState() != 1 || !((PrintConfigDialog)object).getModified()) {
                iJomtEntityStore.abortTransaction();
                return;
            }
            iJomtEntityStore.commitTransaction();
            JomtGlobal.modeManager.changeButtonsState(false);
        }
        catch (Exception exception) {
            iJomtEntityStore.abortTransaction();
            MessageManager.requireBugReport(exception);
        }
    }
}

