/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import net.astah.dd.di.DIPackage;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.golf.draw.GCamera;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.widget.CCanvas;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.swing.SwingCanvas;
import net.astah.jmodel.DiagramEntityClipboard;
import net.astah.jmodel.JmodelPackage;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.CreateTopicsCommand;
import net.astah.jomt.jcontrol.DnDFileCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jsystem.ViewGlobal;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.JomtCanvas;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jviewElement.DiagramViewElement;
import net.astah.jomt.jviewElement.JomtDiagramViewElement;
import net.astah.model.command.AstahPasteFromClipboardCommand;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MindMapUtilties;
import net.astah.uml2.uml.util.PartitionUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.NamedElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasteCommand
extends net.astah.golf.control.Command {
    protected Map param = new HashMap();
    protected Pnt2d pastePosition = null;
    protected IEntityStore doc = null;
    protected DiagramEntityClipboard clipboard = null;
    private String a = null;
    private boolean b = true;
    private static final Logger c = LoggerFactory.getLogger(PasteCommand.class);

    public void setPastePosition(Pnt2d pnt2d) {
        this.pastePosition = pnt2d;
    }

    @Override
    public void setArgumentString(String string) {
        this.a = string;
    }

    @Override
    public void execute() {
        try {
            if (this.a != null) {
                double d2 = Double.valueOf(this.a.substring(0, this.a.indexOf(44)));
                double d3 = Double.valueOf(this.a.substring(this.a.indexOf(44) + 1));
                this.setPastePosition(new Pnt2d(d2, d3));
            }
            this.doc = ModelGlobal.prjManager.getCurrentProject().doc;
            if (this.doc == null) {
                return;
            }
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (diagramEditor == null) {
                return;
            }
            this.clipboard = ViewGlobal.clipboard;
            if (this.clipboard == null) {
                return;
            }
            Diagram diagram = diagramEditor.getDiagram();
            if (diagram == null) {
                return;
            }
            if (!this.isPasteTargetDiagram(diagram)) {
                return;
            }
            Transferable transferable = this.clipboard.getSystemClipboradContent(null);
            if (transferable != null && !this.a(transferable)) {
                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    if (!this.a(diagram)) {
                        MessageManager.displayConfirmMessageDialog("app", "cannot.paste.element.message");
                        return;
                    }
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (!"".equals(string) && (diagram instanceof UMLDiagram && ((UMLDiagram)diagram).isContentsPastable() || MindMapUtilties.isMindMap(diagram))) {
                        if (this.pastePosition == null) {
                            this.pastePosition = this.b(diagramEditor);
                        }
                        if (MindMapUtilties.isMindMap(diagram)) {
                            CreateTopicsCommand createTopicsCommand = new CreateTopicsCommand();
                            createTopicsCommand.setArgumentString(string);
                            createTopicsCommand.setLoction(this.pastePosition);
                            this.callCommand(createTopicsCommand);
                            return;
                        }
                    }
                } else if (!transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor) && transferable.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                    Image image = (Image)transferable.getTransferData(DataFlavor.imageFlavor);
                    CImageIcon cImageIcon = JomtWidgetFactory.instance().createImageIcon(image);
                    if (cImageIcon == null) {
                        MessageManager.displayErrorMessage("app", "too_big_cannot_paste.message");
                        return;
                    }
                    MMTopicShape mMTopicShape = this.a(diagramEditor);
                    DnDFileCommand dnDFileCommand = new DnDFileCommand();
                    dnDFileCommand.setCoveredPresentation(mMTopicShape);
                    dnDFileCommand.setLocation(this.b(diagramEditor));
                    dnDFileCommand.setDropFile(null);
                    dnDFileCommand.setImageIcon(cImageIcon);
                    this.callCommand(dnDFileCommand);
                    return;
                }
                return;
            }
            this.pasteIntoNewDiagram();
            this.clipboard = ViewGlobal.clipboard;
            this.a();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.doc.abortTransaction();
            int n2 = MessageManager.displayMessageOKDialog("app", "out_of_memory.message");
            c.error("OutOfMemoryError has occurred.", outOfMemoryError);
            c.info("choose value: {}", n2);
        }
        catch (Exception exception) {
            c.error("error has occurred.", exception);
            this.doc.abortTransaction();
            MessageManager.requireBugReport(exception);
        }
    }

    private boolean a(Transferable transferable) {
        for (DataFlavor dataFlavor : transferable.getTransferDataFlavors()) {
            if (!"application/vnd.xmi+xml".equals(dataFlavor.getHumanPresentableName())) continue;
            return true;
        }
        return false;
    }

    protected boolean isPasteTargetDiagram(Diagram diagram) {
        return !EObjects.isReadOnly(diagram);
    }

    private boolean a(Diagram diagram) {
        if (PropertyManager.getTarget().equals("J")) {
            return false;
        }
        if (PropertyManager.getTarget().equals("U")) {
            // empty if block
        }
        return true;
    }

    private MMTopicShape a(DiagramEditor diagramEditor) {
        DiagramElement[] diagramElementArray;
        for (DiagramElement diagramElement : diagramElementArray = diagramEditor.getSelectedPresentations()) {
            if (!(diagramElement instanceof MMTopicShape)) continue;
            return (MMTopicShape)diagramElement;
        }
        return null;
    }

    private void a() {
    }

    protected void pasteIntoNewDiagram() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        Diagram diagram = diagramEditor.getDiagram();
        List<DiagramElement> list = Arrays.asList(diagramEditor.getSelectedPresentations());
        DiagramViewElement diagramViewElement = diagramEditor.getDiagramScene().getDiagramViewElement();
        boolean bl = false;
        if (diagramViewElement instanceof JomtDiagramViewElement) {
            bl = diagramViewElement.getCreateEditState();
            diagramViewElement.setCreateEditState(false);
        }
        if (this.pastePosition == null) {
            this.pastePosition = this.b(diagramEditor);
        }
        TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(diagram);
        DiagramContext diagramContext = new DiagramContext(diagram, list, this.pastePosition);
        EReference eReference = diagram instanceof UMLDiagram ? JmodelPackage.Literals.UML_DIAGRAM__PRESENTATIONS : DIPackage.Literals.DIAGRAM_ELEMENT__OWNED_ELEMENT;
        AstahPasteFromClipboardCommand astahPasteFromClipboardCommand = new AstahPasteFromClipboardCommand((EditingDomain)transactionalEditingDomain, (Object)diagramContext, (Object)diagram, eReference, -1);
        try {
            if (astahPasteFromClipboardCommand.canExecute()) {
                CCanvas cCanvas = diagramEditor.getCanvas();
                cCanvas.unselect();
                if (this.useTransaction) {
                    this.doc.beginTransaction();
                }
                CommandUtils.execute(transactionalEditingDomain, (Command)astahPasteFromClipboardCommand);
                if (this.useTransaction) {
                    this.doc.commitTransaction();
                }
                if (astahPasteFromClipboardCommand.getResult().stream().noneMatch(Presentation.class::isInstance)) {
                    for (EObject eObject : list) {
                        if (!(eObject instanceof Presentation)) continue;
                        diagramEditor.select((Presentation)eObject);
                    }
                    diagramEditor.repaintCanvas();
                    diagramEditor.getCanvas().requestFocus();
                    SwingInvoker.runLaterInEDT(() -> this.a(diagramEditor, diagram));
                }
            } else {
                MessageManager.displayErrorMessage("app", "paste_failure.message");
            }
        }
        catch (Exception exception) {
            c.error("error has occurred.", exception);
        }
        if (diagramViewElement instanceof JomtDiagramViewElement) {
            diagramViewElement.setCreateEditState(bl);
        }
    }

    private void a(DiagramEditor diagramEditor, Diagram diagram) {
        if (diagram instanceof MMDiagram) {
            diagramEditor.setNeedInitializeSearchToolBar(true);
        }
    }

    private Pnt2d b(DiagramEditor diagramEditor) {
        if (this.pastePosition != null) {
            this.a(diagramEditor, this.pastePosition);
            return this.pastePosition;
        }
        double d2 = 50.0;
        double d3 = 50.0;
        Point point = this.c(diagramEditor);
        if (point != null) {
            d2 = point.x;
            d3 = point.y;
        }
        GCamera gCamera = diagramEditor.getCamera();
        Pnt2d pnt2d = new Pnt2d(gCamera.toWorldCoordX((int)d2), gCamera.toWorldCoordY((int)d3));
        if (diagramEditor.getDiagram() instanceof UMLActivityDiagram) {
            this.a(diagramEditor, pnt2d);
        }
        return pnt2d;
    }

    private Point c(DiagramEditor diagramEditor) {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        Point point = pointerInfo.getLocation();
        JomtCanvas jomtCanvas = (JomtCanvas)((SwingCanvas)diagramEditor.getCanvas()).getComponent();
        SwingUtilities.convertPointFromScreen(point, jomtCanvas);
        if (!jomtCanvas.contains(point.x, point.y)) {
            return null;
        }
        return point;
    }

    private void a(DiagramEditor diagramEditor, Pnt2d pnt2d) {
        if (diagramEditor.getDiagram() instanceof UMLActivityDiagram && this.a((UMLActivityDiagram)diagramEditor.getDiagram())) {
            double d2 = PartitionUtil.getLowestLaneStartX((UMLActivityDiagram)diagramEditor.getDiagram());
            double d3 = PartitionUtil.getLowestLaneStartY((UMLActivityDiagram)diagramEditor.getDiagram());
            if (d2 > 0.0 && pnt2d.x < d2) {
                pnt2d.x = d2 + 10.0;
            } else if (pnt2d.x < 0.0) {
                pnt2d.x = 10.0;
            }
            if (d3 > 0.0 && pnt2d.y < d3) {
                pnt2d.y = d3 + 10.0;
            } else if (pnt2d.y < 0.0) {
                pnt2d.y = 10.0;
            }
        }
    }

    private boolean a(UMLActivityDiagram uMLActivityDiagram) {
        for (Presentation presentation : uMLActivityDiagram.getPresentations()) {
            if (!(presentation.getModel() instanceof ActivityPartition)) continue;
            return true;
        }
        return false;
    }

    public void setShowAlertMessage(boolean bl) {
        this.b = bl;
    }

    public boolean isShowAlertMessage() {
        return this.b;
    }

    protected boolean isValidSelectedPresentationToCopyFeature(Presentation presentation) {
        return true;
    }

    protected String getModelName(NamedElement namedElement) {
        return namedElement.getName();
    }
}

