/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import net.astah.golf.control.Command;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jmodel.EMFJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.ClosePrjCommand;
import net.astah.jomt.jcontrol.OpenPrjCommand;
import net.astah.jomt.jcontrol.SavePrjSeqCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.MacFilenameFilter;
import net.astah.jomt.jview.MessageManager;

public class OpenPrjSeqCommand
extends Command {
    File a;
    boolean b = false;
    boolean c = false;

    @Override
    public void setArgumentString(String string) {
        for (String string2 : Project.getExtensions()) {
            if (string.indexOf(string2 + ",") == -1) continue;
            int n2 = string.indexOf(string2 + ",") + string2.length();
            string = string.replace(string.substring(n2), "");
        }
        this.a = new File(string);
    }

    public void setLockMode(boolean bl) {
        this.b = bl;
    }

    public void setAllowReadOnly(boolean bl) {
        this.c = bl;
    }

    @Override
    public void execute() {
        block14: {
            try {
                Object object;
                Project project = ModelGlobal.prjManager.getCurrentProject();
                if (project != null && project.doc.isModified()) {
                    int n2 = MessageManager.displayMessageYesNoDialog("app", "ask_save_file.message");
                    if (n2 == 0) {
                        object = new SavePrjSeqCommand();
                        ((SavePrjSeqCommand)object).setShowProgress(false);
                        this.callCommand((Command)object);
                        if (!((SavePrjSeqCommand)object).getExitState()) {
                            return;
                        }
                    } else if (n2 == 2) {
                        return;
                    }
                }
                if (this.a == null) {
                    Object object2;
                    if (PropertyManager.isMacOS()) {
                        object2 = (Frame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
                        object = new FileDialog((Frame)object2);
                        ((FileDialog)object).setMode(0);
                        ((FileDialog)object).setFilenameFilter(new MacFilenameFilter());
                        ((FileDialog)object).setDirectory(JomtGlobal.getFileDir());
                        ((Dialog)object).setVisible(true);
                        this.a = ((FileDialog)object).getFile() == null ? null : new File(GolfUtilities.normalizeToNFC(((FileDialog)object).getDirectory() + ((FileDialog)object).getFile()));
                    } else {
                        object2 = JomtWidgetFactory.instance().createCommonOpenFileDialog();
                        this.a = object2.open();
                    }
                    if (this.a == null) {
                        return;
                    }
                }
                if (project != null) {
                    ClosePrjCommand closePrjCommand = this.getClosePrjCommand();
                    closePrjCommand.setProject(project);
                    closePrjCommand.a(false);
                    this.callCommand(closePrjCommand);
                    closePrjCommand.a(true);
                }
                JomtGlobal.setFileDir(this.a.getParent());
                if (Project.isSupportedExtension(this.a)) {
                    this.a(this.a);
                    break block14;
                }
                File file = new File(this.a.getAbsolutePath() + Project.FILE_EXTENTION_ASTA);
                if (file.canRead()) {
                    this.a(file);
                    break block14;
                }
                MessageManager.displayErrorMessage("app", "tell_open_fail.message");
                return;
            }
            catch (Exception exception) {
                MessageManager.requireBugReport(exception);
            }
        }
    }

    private void a(File file) {
        Project project = this.getNewProject();
        OpenPrjCommand openPrjCommand = this.getOpenPrjCommand();
        openPrjCommand.setProject(project);
        openPrjCommand.setFile(file);
        openPrjCommand.setLockMode(this.b);
        openPrjCommand.setAllowReadOnly(this.c);
        if (JomtGlobal.isRunByOtherTool()) {
            openPrjCommand.setIsProgress(false);
            openPrjCommand.setNoThread(true);
            this.callCommand(openPrjCommand, 1);
            return;
        }
        if (JomtGlobal.isPlugIn) {
            openPrjCommand.setIsProgress(false);
            openPrjCommand.setNoThread(true);
            this.callCommand(openPrjCommand, 1);
            return;
        }
        this.callCommand(openPrjCommand, 2);
    }

    protected Project getNewProject() {
        return new Project(new EMFJomtEntityStore());
    }

    protected OpenPrjCommand getOpenPrjCommand() {
        return new OpenPrjCommand();
    }

    protected ClosePrjCommand getClosePrjCommand() {
        return new ClosePrjCommand();
    }
}

