/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Color;
import java.awt.Point;
import java.lang.reflect.InvocationTargetException;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.golf.control.Command;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.CFrame;
import net.astah.golf.widget.CJDialog;
import net.astah.golf.widget.swing.SwingColor;
import net.astah.golf.widget.swing.SwingIconRegistry;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.S;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.CModelPane;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.PropertyWindow;
import net.astah.jomt.jview.proptab.ModelPane;
import net.astah.jomt.jview.proptab.ModelTab;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import net.astah.jomt.jview.swing.C;
import net.astah.jomt.jview.swing.D;
import org.eclipse.emf.ecore.EObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OpenNewPropertyViewCommand
extends Command {
    protected EObject model;
    private static final Logger a = LoggerFactory.getLogger(OpenNewPropertyViewCommand.class);
    protected PropertyWindow propertyWindow;

    public void setModel(EObject eObject) {
        this.model = eObject;
    }

    public EObject getModel() {
        return this.model;
    }

    @Override
    public void execute() {
        try {
            if (this.model == null) {
                this.model = this.getCurrentModel();
                if (this.model == null) {
                    return;
                }
            }
            try {
                S s2 = new S(this);
                SwingInvoker.runInEDTAndWait(s2);
            }
            catch (InterruptedException interruptedException) {
                a.info("interrupted.");
            }
            catch (InvocationTargetException invocationTargetException) {
                a.error("error has occurred.", invocationTargetException);
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected boolean customizePropertyView() {
        return true;
    }

    protected abstract EObject getCurrentModel();

    protected PropertyView getPropertyView(Project project) {
        return new PropertyView((CModelPane)JomtWidgetFactory.instance().createModelPane(project));
    }

    protected int getSelectIndex() {
        return 0;
    }

    protected void openPropertyDialog() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        if (diagramEditor != null) {
            diagramEditor.removeEditingNodeFocus();
        }
        Project project = ModelGlobal.prjManager.getCurrentProject();
        CFrame cFrame = (CFrame)JomtGlobal.viewManager.getManagementView().getComponent();
        PropertyView propertyView = this.getPropertyView(project);
        this.propertyWindow = this.createPropertyWindow(propertyView, cFrame, true);
        String string = this.getDialogTitle();
        this.propertyWindow.getDialog().setTitle(string);
        this.propertyWindow.getDialog().setLocation(new Point(200, 200));
        this.setWindowSize(propertyView);
        this.propertyWindow.getDialog().setLocationRelativeTo(cFrame.getComponent());
        propertyView.updateProperty(this.model);
        D d2 = (D)propertyView.uiViewPeer;
        C c2 = (C)d2.getModelPane();
        ModelPane modelPane = (ModelPane)c2.getComponent();
        ModelTabGroup modelTabGroup = modelPane.getCurrentModelTabGroup();
        modelTabGroup.setSelectedIndex(this.getSelectIndex());
        JomtGlobal.viewManager.addPropertyWindow(this.propertyWindow);
        JomtGlobal.viewManager.addPropertyView(propertyView);
        if (this.customizePropertyView()) {
            this.removeButtonPanel();
            this.propertyWindow.getDialog().setVisible(true);
        }
    }

    protected String getDialogTitle() {
        return LabelProviders.getTypeText(this.model);
    }

    protected void setWindowSize(PropertyView propertyView) {
        CJDialog cJDialog = this.propertyWindow.getDialog();
        double d2 = SwingIconRegistry.getDefaultScale();
        if (GolfUtilities.isMacOS()) {
            cJDialog.setSize((int)Math.ceil(400.0 * d2), (int)Math.ceil(450.0 * d2));
            this.propertyWindow.setBackground(new SwingColor(Color.LIGHT_GRAY));
        } else {
            cJDialog.setSize((int)Math.ceil(300.0 * d2), (int)Math.ceil(350.0 * d2));
        }
        propertyView.getModelPane().setSize(100, 100);
    }

    protected void removeButtonPanel() {
    }

    protected PropertyWindow createPropertyWindow(PropertyView propertyView, CFrame cFrame, boolean bl) {
        return new PropertyWindow(propertyView, cFrame, true);
    }

    protected ModelTab getModelTab() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTab modelTab = propertyView.getModelPane().getCurrentModelTabGroup().getCurrentModelTab();
        return modelTab;
    }
}

