/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.UMLActivityDiagram;
import net.astah.jomt.jcontrol.ClassifierFactory;
import net.astah.jomt.jcontrol.CreateClassifierFromPrjCommand;
import net.astah.jomt.jcontrol.OpenClassifierPropertyViewCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.LifelineBaseTab;
import net.astah.jomt.jview.proptab.ModelTab;
import net.astah.jomt.jview.proptab.ObjectBaseTab;
import net.astah.jomt.jview.proptab.ObjectNodeBaseTab;
import net.astah.jomt.jview.proptab.PortBaseTab;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.ObjectNode;
import org.eclipse.uml2.uml.Port;

public class OpenNewClassifierPropertyViewCommand
extends CreateClassifierFromPrjCommand {
    @Override
    protected Namespace getParentPackage() {
        Element element;
        Port port;
        ModelTab modelTab = this.getModelTab();
        if (modelTab instanceof LifelineBaseTab) {
            Namespace namespace;
            Lifeline lifeline = (Lifeline)modelTab.getModel();
            if (lifeline != null && (namespace = lifeline.getNamespace()) != null) {
                return namespace.getNamespace();
            }
        } else if (modelTab instanceof ObjectBaseTab) {
            InstanceSpecification instanceSpecification = (InstanceSpecification)modelTab.getModel();
            if (instanceSpecification != null) {
                return instanceSpecification.getNamespace();
            }
        } else if (modelTab instanceof ObjectNodeBaseTab) {
            ObjectNode objectNode = (ObjectNode)modelTab.getModel();
            if (objectNode != null) {
                Presentation presentation = Presentations.getPresentation(objectNode);
                UMLActivityDiagram uMLActivityDiagram = (UMLActivityDiagram)presentation.getDiagram();
                Activity activity = uMLActivityDiagram.getActivityGraph();
                if (activity.getPackage() != null) {
                    return activity.getPackage();
                }
                if (activity.getContext() != null) {
                    return activity.getContext().getNearestPackage();
                }
            }
        } else if (modelTab instanceof PortBaseTab && (port = (Port)modelTab.getModel()) != null && (element = port.getOwner()) != null && element instanceof NamedElement) {
            return ((NamedElement)element).getNamespace();
        }
        return null;
    }

    protected ModelTab getModelTab() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTab modelTab = propertyView.getModelPane().getCurrentModelTabGroup().getCurrentModelTab();
        return modelTab;
    }

    @Override
    protected Classifier createNewClassifier(IEntityStore iEntityStore, Namespace namespace) {
        return ClassifierFactory.createClass(iEntityStore, namespace, null);
    }

    @Override
    protected void postCreating() {
        if (this.newClassifier == null) {
            return;
        }
        OpenClassifierPropertyViewCommand openClassifierPropertyViewCommand = new OpenClassifierPropertyViewCommand();
        openClassifierPropertyViewCommand.setModel(this.newClassifier);
        this.callCommand(openClassifierPropertyViewCommand);
    }
}

