/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.List;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GPolyline;
import net.astah.golf.draw.GRect;
import net.astah.golf.draw.GRoundRect;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.widget.CCanvas;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.GNodeSearchEngineUtil;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jviewElement.JomtViewElement;
import net.astah.jomt.jviewElement.SwingJomtTextAreaNode;
import net.astah.jomt.jviewElement.SwingJomtTextFieldNode;

public class OpenDiagramSearchCommand
extends Command {
    @Override
    public void execute() {
        try {
            DiagramEditor diagramEditor;
            if (JomtGlobal.viewManager != null && !PropertyManager.getTarget().equals("J") && (diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor()) != null) {
                diagramEditor.setSearchToolBarVisibility(true);
                CCanvas cCanvas = diagramEditor.getCanvas();
                List<GNode> list = cCanvas.getSelectedNodes();
                String string = "";
                for (GNode gNode : list) {
                    if (gNode instanceof GRect && ((GRect)gNode).isVisible() || gNode instanceof GRoundRect && ((GRoundRect)gNode).isVisible() || gNode instanceof GPolyline && ((GPolyline)gNode).isVisible()) {
                        gNode = gNode.getParent();
                    }
                    if (!(gNode instanceof JomtViewElement && gNode.isVisible() || gNode instanceof SwingJomtTextFieldNode && gNode.isVisible()) && (!(gNode instanceof SwingJomtTextAreaNode) || !gNode.isVisible()) || "".equals(string = GNodeSearchEngineUtil.transferString(gNode, true)) || " ".equals(string)) continue;
                    break;
                }
                if (!"".equals(string)) {
                    diagramEditor.setSearchToolBarChar(string);
                }
            }
        }
        catch (BadTransactionException badTransactionException) {
            MessageManager.requireBugReport(badTransactionException);
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }
}

