/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.KeyStroke;
import net.astah.dd.di.Diagram;
import net.astah.emf.edit.provider.ItemProviders;
import net.astah.golf.control.GolfAction;
import net.astah.golf.control.KeybindMode;
import net.astah.golf.control.Mode;
import net.astah.golf.draw.GCamera;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.util.ResourceBundleList;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.UIView;
import net.astah.golf.widget.CDesktopPane;
import net.astah.golf.widget.swing.SwingCanvas;
import net.astah.jmodel.DiagramViewInfo;
import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.TaggedValueUtilities;
import net.astah.jomt.jcontrol.AbstractEditorOpenCommand;
import net.astah.jomt.jcontrol.mode.DefaultSelectionMode;
import net.astah.jomt.jcontrol.mode.DiagramMode;
import net.astah.jomt.jcontrol.mode.DiagramPopupMode;
import net.astah.jomt.jcontrol.mode.DirectEditingMode;
import net.astah.jomt.jcontrol.mode.IconButtonMode;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jsystem.ViewGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.DiagramEditorPeer;
import net.astah.jomt.jview.ManagementView;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.DiagramOperations;
import net.astah.notation.editor.IItemEditorFactory;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMTopicShape;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenDiagramEditorCommand
extends AbstractEditorOpenCommand {
    protected DiagramViewInfo dgmViewInfo;
    protected DiagramEditor de;
    private static final Logger a = LoggerFactory.getLogger(OpenDiagramEditorCommand.class);

    @Override
    public void setModel(Object object) {
        URI uRI;
        if (object instanceof Diagram && (uRI = EcoreUtil.getURI((Diagram)object)) != null) {
            this.setArgumentString(uRI.toString());
        }
    }

    @Override
    public void setArgumentString(String string) {
        EditingDomain editingDomain = EntityAccessor.getCurrentDomain();
        if (editingDomain != null) {
            try {
                URI uRI = URI.createURI(string);
                EObject eObject = editingDomain.getResourceSet().getEObject(uRI, true);
                if (eObject instanceof Diagram) {
                    Diagram diagram = (Diagram)eObject;
                    DiagramViewInfo diagramViewInfo = new DiagramViewInfo(diagram, new GCamera());
                    this.setDiagramViewInfo(diagramViewInfo);
                }
            }
            catch (Exception exception) {
                a.warn("Cannot open diagram editor", exception);
            }
        }
    }

    public void setDiagramViewInfo(DiagramViewInfo diagramViewInfo) {
        this.dgmViewInfo = diagramViewInfo;
    }

    @Override
    public void execute() {
        if (this.dgmViewInfo == null) {
            this.dgmViewInfo = this.getDiagramViewInfo();
        }
        if (this.dgmViewInfo == null || this.dgmViewInfo.getDiagram() == null) {
            return;
        }
        if (this.dgmViewInfo.getCamera() == null) {
            this.dgmViewInfo.setCamera(new GCamera());
        }
        JomtGlobal.viewManager.beginWaitCursor();
        try {
            MMDiagram mMDiagram;
            MMTopicShape mMTopicShape;
            Object object;
            Object object2;
            Object object3;
            JomtGlobal.viewManager.getNavigationManager().setPreviousEditor(JomtGlobal.viewManager.getCurrentEditor());
            boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.editor.do_auto_pan_to_show");
            DiagramMode.setDoAutoPanToShow(bl);
            boolean bl2 = RuntimeGlobal.sysProp.getBooleanWithDefault("basic.allow_multi_editor");
            Diagram diagram = this.dgmViewInfo.getDiagram();
            if (!bl2 && (object3 = this.a(diagram)) != null) {
                this.c((DiagramEditor)object3);
                JomtGlobal.viewManager.endWaitCursor();
                this.de = object3;
                this.doAfterActivateDiagramEditor();
                return;
            }
            object3 = JomtGlobal.viewManager.getManagementView().getDesktopPane();
            this.de = this.getDiagramEditor((CDesktopPane)object3);
            if (!ViewGlobal.editorAlignKeeper.isKeeping()) {
                this.de.maximize();
            }
            if (DiagramOperations.onlySelectionAndPopUpMode(diagram) || TaggedValueUtilities.isTraceabilityMap(diagram)) {
                object2 = this.de.getCanvasUIView();
                ((UIView)object2).addDefaultMode(this.a(this.de));
            } else {
                object2 = this.b(this.de);
                this.setToggleButtonMode(this.de);
                object = this.de.getCanvasUIView();
                ((UIView)object).addDefaultMode(object2.toArray(new Mode[0]));
                if (((UIView)object).getComponent() instanceof SwingCanvas) {
                    ((SwingCanvas)((UIView)object).getComponent()).component.setFocusTraversalKeysEnabled(false);
                }
            }
            JomtGlobal.viewManager.addEditor(this.de);
            object2 = JomtGlobal.viewManager.getManagementView();
            ((ManagementView)object2).setDgmEditorActionStateInfo(this.de);
            object = ModelGlobal.prjManager.getCurrentProject();
            this.de.setProjectActionStateInfo((Project)object);
            this.de.activated();
            JomtGlobal.modeManager.setMode(PropertyManager.getJudeResourceBundle().getString("jude.default_selection_command_manager"));
            if (RuntimeGlobal.sysProp.getBooleanWithDefault("basic.open_dgm_at_coordinate_on_topleft")) {
                this.de.scrollToTopLeftCorner();
            }
            if (diagram instanceof MMDiagram && RuntimeGlobal.sysProp.getBooleanWithDefault("basic.show_root_at_the_center") && (mMTopicShape = (mMDiagram = (MMDiagram)diagram).getRoot()) != null) {
                this.de.scrollToTargetPresentation(mMTopicShape);
            }
        }
        catch (BadTransactionException badTransactionException) {
            MessageManager.requireBugReport(badTransactionException);
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
        this.doAfterOpenDiagramEditor();
        JomtGlobal.viewManager.endWaitCursor();
    }

    protected void doAfterActivateDiagramEditor() {
    }

    protected void doAfterOpenDiagramEditor() {
    }

    protected DiagramEditor getDiagramEditor(CDesktopPane cDesktopPane) {
        return new DiagramEditor(this.dgmViewInfo, cDesktopPane);
    }

    protected DiagramViewInfo getDiagramViewInfo() {
        return null;
    }

    private Mode[] a(DiagramEditor diagramEditor) {
        ArrayList<DiagramMode> arrayList = new ArrayList<DiagramMode>();
        if (diagramEditor != null) {
            ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
            if (resourceBundleList != null) {
                try {
                    String string = resourceBundleList.getString("jude.default_selection_mode_manager");
                    Class<?> clazz = Class.forName(string);
                    DefaultSelectionMode defaultSelectionMode = (DefaultSelectionMode)clazz.newInstance();
                    arrayList.add(defaultSelectionMode);
                    String string2 = resourceBundleList.getString("jude.diagram_popup_mode_manager");
                    Class<?> clazz2 = Class.forName(string2);
                    DiagramPopupMode diagramPopupMode = (DiagramPopupMode)clazz2.newInstance();
                    arrayList.add(diagramPopupMode);
                }
                catch (Exception exception) {
                    a.error("error has occurred.", exception);
                }
            }
            for (Object e2 : arrayList) {
                if (!(e2 instanceof DiagramMode)) continue;
                ((DiagramMode)e2).setDiagramEditor(diagramEditor);
            }
        }
        return arrayList.toArray(new Mode[arrayList.size()]);
    }

    public void setToggleButtonMode(DiagramEditor diagramEditor) {
        Diagram diagram = diagramEditor.getDiagram();
        IItemEditorFactory iItemEditorFactory = ItemProviders.adapt(diagram, IItemEditorFactory.class);
        if (iItemEditorFactory != null) {
            String string = iItemEditorFactory.getSelectedLineShape(diagram);
            String string2 = "line";
            if (!Strings.isNullOrEmpty(string)) {
                string2 = RuntimeGlobal.sysProp.getStringWithDefault(string);
            }
            JomtGlobal.modeManager.setLineShapeButtonMode(diagramEditor, string2);
            if (string2.equals("line_right_angle")) {
                DiagramEditorPeer diagramEditorPeer = (DiagramEditorPeer)diagramEditor.getUiViewPeer();
                diagramEditorPeer.setToggleButtonState("ModifySetCenterPntMode", false);
                diagramEditor.getDiagramScene().getDiagramViewInfo().setSetCenterPntMode(false);
            }
            boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("uml.sequence_diagram.return_message_automatic_mode.selected");
            JomtGlobal.modeManager.setReturnMsgAutomaticButtonMode(diagramEditor, bl);
        }
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("diagram.editor.icon_button");
        JomtGlobal.modeManager.setEnableDrawSuggest(diagramEditor, bl);
    }

    private List<Mode> b(DiagramEditor diagramEditor) {
        Iterator iterator;
        Object object;
        ArrayList<Mode> arrayList = new ArrayList<Mode>();
        Diagram diagram = diagramEditor.getDiagram();
        arrayList.add(this.a(diagramEditor.getActionTable(), diagram));
        arrayList.add(new DirectEditingMode(diagramEditor.getActionTable()));
        ResourceBundleList resourceBundleList = PropertyManager.getJudeResourceBundle();
        if (resourceBundleList != null) {
            try {
                object = resourceBundleList.getString("jude.default_selection_mode_manager");
                iterator = Class.forName((String)object);
                DefaultSelectionMode mode = (DefaultSelectionMode)((Class)((Object)iterator)).newInstance();
                arrayList.add(mode);
            }
            catch (Exception exception) {
                a.error("error has occurred.", exception);
            }
        }
        if ((object = ItemProviders.adapt(diagram, IItemEditorFactory.class)) != null && (iterator = object.createModes(diagram)) != null) {
            arrayList.addAll((Collection<Mode>)((Object)iterator));
        }
        arrayList.add(new IconButtonMode());
        for (Mode mode : arrayList) {
            if (!(mode instanceof DiagramMode)) continue;
            DiagramMode diagramMode = (DiagramMode)mode;
            diagramMode.setDiagramEditor(diagramEditor);
        }
        return arrayList;
    }

    private void c(DiagramEditor diagramEditor) {
        JomtGlobal.viewManager.activateEditor(diagramEditor);
    }

    private DiagramEditor a(Diagram diagram) {
        List<DiagramEditor> list = JomtGlobal.viewManager.getAllDiagramEditors();
        for (DiagramEditor diagramEditor : list) {
            if (diagramEditor.getDiagram() != diagram) continue;
            return diagramEditor;
        }
        return null;
    }

    private KeybindMode a(Map<String, Action> map, Diagram diagram) {
        KeybindMode keybindMode = new KeybindMode();
        this.a(keybindMode, map, "diagramview.action.start_editing_node.key", "StartEditingNode");
        String string = PropertyManager.getDiagramEditorResourceBundle().getString("diagram.editor.action.create_attribute");
        this.a(keybindMode, map, "diagramview.popupmenu.attribute.key", string);
        String string2 = PropertyManager.getDiagramEditorResourceBundle().getString("diagram.editor.action.create_method");
        this.a(keybindMode, map, "diagramview.popupmenu.method.key", string2);
        String string3 = PropertyManager.getDiagramEditorResourceBundle().getString("diagram.editor.action.create_enumeration_literal");
        this.a(keybindMode, map, "diagramview.popupmenu.enumeration_literal.key", string3);
        String string4 = PropertyManager.getDiagramEditorResourceBundle().getString("diagram.editor.action.create_stereotype_from_prj");
        this.a(keybindMode, map, "diagramview.popupmenu.add_stereotype.key", string4);
        String string5 = PropertyManager.getDiagramEditorResourceBundle().getString("diagram.editor.action.pressed_enter");
        this.a(keybindMode, map, "diagramview.action.dgm_editor_pressed_enter.key", string5);
        String string6 = PropertyManager.getJudeResourceBundle().getString("jude.default_selection_command_manager");
        this.a(keybindMode, map, "diagramview.action.default_selection_mode.key", string6);
        this.a(keybindMode, map, "diagramview.action.toggle_font_bold.key", "ToggleFontBold");
        this.a(keybindMode, map, "diagramview.action.toggle_font_italic.key", "ToggleFontItalic");
        String string7 = PropertyManager.getDiagramEditorResourceBundle().getString("diagram.editor.action.move_up");
        this.a(keybindMode, map, "diagramview.action.dgm_editor_move_up.key", string7);
        String string8 = PropertyManager.getDiagramEditorResourceBundle().getString("diagram.editor.action.move_down");
        this.a(keybindMode, map, "diagramview.action.dgm_editor_move_down.key", string8);
        if (PropertyManager.getTarget().equals("T")) {
            this.a(map, keybindMode);
        }
        return keybindMode;
    }

    private void a(Map<String, Action> map, KeybindMode keybindMode) {
        String string = "DeleteFromModel";
        Action action = map.get(string);
        if (action == null) {
            action = new GolfAction(string);
        }
        this.a(keybindMode, "diagramview.popupmenu.delete_from_model.key", action);
    }

    private void a(KeybindMode keybindMode, Map<String, Action> map, String string, String string2) {
        Action action = map.get(string2);
        this.a(keybindMode, string, action);
    }

    private void a(KeybindMode keybindMode, String string, Action action) {
        ResourceBundleList resourceBundleList = PropertyManager.getDiagramEditorResourceBundle();
        String string2 = resourceBundleList.getString(string);
        this.a(keybindMode, action, string2);
    }

    private void a(KeybindMode keybindMode, Action action, String string) {
        if (string != null) {
            KeyStroke keyStroke;
            if (PropertyManager.isMacOS()) {
                if ((string = string.replaceFirst("control", "meta")).indexOf("meta") >= 0) {
                    string = string.replaceFirst("released", "pressed");
                }
                string = string.replaceFirst("DELETE", "BACK_SPACE");
            }
            if ((keyStroke = KeyStroke.getKeyStroke(string)) != null) {
                keybindMode.registerKeybind(keyStroke, action);
            }
        }
    }

    protected Presentation getCenterPs() {
        return null;
    }
}

