/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.model.IStyleMapOwner;
import net.astah.golf.widget.CColor;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.NoteAnchorUtil;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Presentations;
import net.astah.jmodel.Project;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.StyleSupport;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.Defaults;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.uml.Classifiers;
import net.astah.uml2.uml.Enumerations;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OperationOwner;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Property;

public class MoveFeaturePatternCommand
extends Command {
    protected RectPresentation containerPs;
    protected List<Feature> features = new ArrayList<Feature>();
    protected List<EnumerationLiteral> enumerationLiterals = new ArrayList<EnumerationLiteral>();
    private int a;

    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        if (iJomtEntityStore == null) {
            return;
        }
        if (this.features == null || this.features.isEmpty() && (this.enumerationLiterals == null || this.enumerationLiterals.isEmpty())) {
            return;
        }
        if (this.containerPs == null || !this.isTargetContainer(this.containerPs.getModel())) {
            return;
        }
        Classifier classifier = (Classifier)this.containerPs.getModel();
        this.a();
        if (this.b()) {
            return;
        }
        try {
            try {
                Object object;
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                if (!this.features.isEmpty()) {
                    object = this.getIndexFeature();
                    this.a(classifier, (Feature)object);
                    this.a(iJomtEntityStore, classifier, (NamedElement)object);
                } else if (!this.enumerationLiterals.isEmpty()) {
                    object = this.getIndexEnumerationLiteral();
                    this.a(classifier, (EnumerationLiteral)object);
                    this.a(iJomtEntityStore, classifier, (NamedElement)object);
                }
                for (Object e2 : this.features) {
                    this.synchronizePresentations((Element)e2);
                }
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private void a() {
        this.features = this.a(this.features);
        this.enumerationLiterals = this.a(this.enumerationLiterals);
    }

    protected boolean isTargetContainer(EObject eObject) {
        return this.containerPs.getModel() instanceof Classifier;
    }

    private List a(List list) {
        ArrayList<NamedElement> arrayList = new ArrayList<NamedElement>();
        for (Element element : this.b(list)) {
            if (!(element instanceof Classifier)) continue;
            arrayList.addAll(this.a((Classifier)element, list));
        }
        return arrayList;
    }

    private Collection<Element> b(List list) {
        HashSet<Element> hashSet = new HashSet<Element>();
        for (Object e2 : list) {
            if (e2 instanceof Feature) {
                hashSet.add(((Feature)e2).getOwner());
                continue;
            }
            if (!(e2 instanceof EnumerationLiteral)) continue;
            hashSet.add(((EnumerationLiteral)e2).getOwner());
        }
        return hashSet;
    }

    private List<NamedElement> a(Classifier classifier, List list) {
        ArrayList<NamedElement> arrayList = new ArrayList<NamedElement>();
        arrayList.addAll(((AttributeOwner)((Object)classifier)).getOwnedAttributes());
        arrayList.addAll(((OperationOwner)((Object)classifier)).getOwnedOperations());
        if (classifier instanceof Enumeration) {
            arrayList.addAll(((Enumeration)classifier).getOwnedLiterals());
        }
        ArrayList<NamedElement> arrayList2 = new ArrayList<NamedElement>();
        for (NamedElement namedElement : arrayList) {
            if (!list.contains(namedElement)) continue;
            arrayList2.add(namedElement);
        }
        return arrayList2;
    }

    private List<Feature> a(Classifier classifier, Feature feature) throws InterruptedException, RollbackException {
        ArrayList<Feature> arrayList = new ArrayList<Feature>();
        for (int i2 = 0; i2 < this.features.size(); ++i2) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Feature feature2 = this.features.get(i2);
            if (feature2 == feature) continue;
            if (!feature2.getNamespace().equals(classifier)) {
                arrayList.add(feature2);
                this.a(feature2);
                NoteAnchorUtil.updateNoteAnchor(feature2, classifier);
            }
            Element element = feature2.getOwner();
            if (feature2 instanceof Property) {
                object4 = (Property)feature2;
                ((AttributeOwner)((Object)classifier)).getOwnedAttributes().add((Property)object4);
                object3 = ((Namespace)element).getOwnedRules().stream().filter(arg_0 -> MoveFeaturePatternCommand.a((Property)object4, arg_0)).collect(Collectors.toList());
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = (Constraint)object2.next();
                    object.setContext(classifier);
                }
            } else {
                object4 = (Operation)feature2;
                ((OperationOwner)((Object)classifier)).getOwnedOperations().add((Operation)object4);
            }
            object4 = Presentations.getPresentations(element);
            object3 = object4.iterator();
            while (object3.hasNext()) {
                CColor cColor;
                object2 = (Presentation)object3.next();
                if (!object2.getDiagram().equals(this.containerPs.getDiagram()) || element.equals(classifier) || (object = object2.getStyleMap()) == null || (cColor = StyleSupport.getValueCColor((IStyleMapOwner)object2, StyleSupport.getSubItemFontColorKey(feature2))) == null) continue;
                object2.removeSubItemFontColorId(feature2);
                this.containerPs.setSubItemFontColor(feature2, cColor);
                if (!(feature2 instanceof Property)) continue;
                this.a((Property)feature2);
            }
        }
        return arrayList;
    }

    private List<EnumerationLiteral> a(Classifier classifier, EnumerationLiteral enumerationLiteral) throws InterruptedException, RollbackException {
        ArrayList<EnumerationLiteral> arrayList = new ArrayList<EnumerationLiteral>();
        for (int i2 = 0; i2 < this.enumerationLiterals.size(); ++i2) {
            EnumerationLiteral enumerationLiteral2 = this.enumerationLiterals.get(i2);
            if (enumerationLiteral2 == enumerationLiteral) continue;
            if (!enumerationLiteral2.getNamespace().equals(classifier)) {
                arrayList.add(enumerationLiteral2);
                NoteAnchorUtil.updateNoteAnchor(enumerationLiteral2, classifier);
            }
            Element element = enumerationLiteral2.getOwner();
            ((Enumeration)classifier).getOwnedLiterals().add(enumerationLiteral2);
            List<Presentation> list = Presentations.getPresentations(element);
            for (Presentation presentation : list) {
                CColor cColor;
                Map<String, String> map;
                if (!presentation.getDiagram().equals(this.containerPs.getDiagram()) || element.equals(classifier) || (map = presentation.getStyleMap()) == null || (cColor = StyleSupport.getValueCColor(presentation, StyleSupport.getSubItemFontColorKey(enumerationLiteral2))) == null) continue;
                presentation.removeSubItemFontColorId(enumerationLiteral2);
                this.containerPs.setSubItemFontColor(enumerationLiteral2, cColor);
            }
        }
        return arrayList;
    }

    private void a(Property property) {
        Element element = property.getOwner();
        if (element instanceof Classifier) {
            EList<InstanceSpecification> eList = Classifiers.getInstanceSpecifications((Classifier)element);
            for (InstanceSpecification instanceSpecification : eList) {
                List<Presentation> list = Presentations.getPresentations(instanceSpecification);
                for (Presentation presentation : list) {
                    presentation.removeSubItemFontColorId(property);
                }
            }
        }
    }

    private void a(Feature feature) {
        if (feature instanceof Property) {
            Property property = (Property)feature;
            if (property.getType() instanceof Classifier && ((Classifier)property.getType()).getOwningTemplateParameter() != null) {
                property.setType(Defaults.getAttrDefType());
            }
        } else if (feature instanceof Operation) {
            for (Parameter parameter : ((Operation)feature).getOwnedParameters()) {
                if (parameter.getType() == null || parameter.getType().getOwningTemplateParameter() == null) continue;
                if (parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                    parameter.setType(null);
                    continue;
                }
                parameter.setType(Defaults.getOperationParameterDefaultType());
            }
        }
    }

    protected Feature getIndexFeature() {
        Feature feature = null;
        Classifier classifier = (Classifier)this.containerPs.getModel();
        if (Classifiers.isAllAttributes(this.features)) {
            EList<Property> eList = ((AttributeOwner)((Object)classifier)).getOwnedAttributes();
            feature = this.getIndexProperty(eList);
        } else if (Classifiers.isAllOperations(this.features)) {
            EList<Operation> eList = ((OperationOwner)((Object)classifier)).getOwnedOperations();
            feature = this.getIndexFeature(eList);
        }
        return feature;
    }

    protected EnumerationLiteral getIndexEnumerationLiteral() {
        EnumerationLiteral enumerationLiteral = null;
        Classifier classifier = (Classifier)this.containerPs.getModel();
        if (Enumerations.isAllEnumerationLiterals(this.enumerationLiterals)) {
            EList<EnumerationLiteral> eList = ((Enumeration)classifier).getOwnedLiterals();
            enumerationLiteral = this.getIndexEnumerationLiteral(eList);
        }
        return enumerationLiteral;
    }

    protected Feature getIndexProperty(List<Property> list) {
        int n2;
        if (list.isEmpty()) {
            return null;
        }
        int n3 = 0;
        Element element = list.get(0).getOwner();
        if (element instanceof AttributeOwner) {
            List<Property> list2 = Classifiers.getAllAttributesWithoutAssociations((Classifier)element);
            if (this.a - 1 < 0) {
                return null;
            }
            Property property = list2.get(this.a - 1);
            EList<Property> eList = ((AttributeOwner)((Object)element)).getOwnedAttributes();
            n3 = eList.indexOf(property);
        }
        if ((n2 = n3) < 0 || n2 >= list.size()) {
            return null;
        }
        return list.get(n2);
    }

    protected Feature getIndexFeature(List list) {
        int n2 = this.a - 1;
        if (n2 < 0 || n2 >= list.size()) {
            return null;
        }
        return (Feature)list.get(n2);
    }

    protected EnumerationLiteral getIndexEnumerationLiteral(List list) {
        int n2 = this.a - 1;
        if (n2 < 0 || n2 >= list.size()) {
            return null;
        }
        return (EnumerationLiteral)list.get(n2);
    }

    private void a(IEntityStore iEntityStore, Classifier classifier, NamedElement namedElement) {
        if (!this.features.isEmpty() && (namedElement != null || (Classifiers.isAllAttributes(this.features) || Classifiers.isAllOperations(this.features)) && namedElement == null)) {
            Classifiers.changeFeatureOrder(classifier, (Feature)namedElement, this.features);
        } else if (!this.enumerationLiterals.isEmpty() && (namedElement != null || Enumerations.isAllEnumerationLiterals(this.enumerationLiterals) && namedElement == null)) {
            Enumerations.changeEnumerationLiteralOrder(classifier, (EnumerationLiteral)namedElement, this.enumerationLiterals);
        }
    }

    public void setSelected(List list) {
        this.c(list);
        this.d(list);
    }

    private List<Feature> c(List<EObject> list) {
        for (EObject eObject : list) {
            if (!(eObject instanceof Feature)) continue;
            this.features.add((Feature)eObject);
        }
        return this.features;
    }

    private List<EnumerationLiteral> d(List<EObject> list) {
        for (EObject eObject : list) {
            if (!(eObject instanceof EnumerationLiteral)) continue;
            this.enumerationLiterals.add((EnumerationLiteral)eObject);
        }
        return this.enumerationLiterals;
    }

    public void setContainer(RectPresentation rectPresentation) {
        this.containerPs = rectPresentation;
    }

    public RectPresentation getContainer() {
        return this.containerPs;
    }

    public void setIndex(int n2) {
        this.a = n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean b() {
        List list = null;
        Classifier classifier = (Classifier)this.containerPs.getModel();
        if (!this.features.isEmpty()) {
            if (Classifiers.isAllAttributes(this.features)) {
                list = this.e(((AttributeOwner)((Object)classifier)).getOwnedAttributes());
                return list != null && (list.contains(this.features) || list.contains(this.enumerationLiterals));
            } else {
                if (!Classifiers.isAllOperations(this.features)) return true;
                list = this.e(((OperationOwner)((Object)classifier)).getOwnedOperations());
            }
            return list != null && (list.contains(this.features) || list.contains(this.enumerationLiterals));
        } else {
            if (this.enumerationLiterals.isEmpty()) return list != null && (list.contains(this.features) || list.contains(this.enumerationLiterals));
            if (!Enumerations.isAllEnumerationLiterals(this.enumerationLiterals) || !(classifier instanceof Enumeration)) return true;
            list = this.f(((Enumeration)classifier).getOwnedLiterals());
        }
        return list != null && (list.contains(this.features) || list.contains(this.enumerationLiterals));
    }

    private List e(List list) {
        ArrayList arrayList = new ArrayList();
        if (list.isEmpty()) {
            return arrayList;
        }
        if (this.features.contains(list.get(0)) && this.a <= this.features.size()) {
            for (int i2 = 0; i2 < this.features.size(); ++i2) {
                arrayList.add(list.get(i2));
            }
        } else if (this.features.contains(list.get(list.size() - 1)) && this.a >= list.size() - this.features.size()) {
            for (int i3 = 0; i3 < this.features.size(); ++i3) {
                arrayList.add(0, list.get(list.size() - 1 - i3));
            }
        } else {
            for (int i4 = 0; i4 < list.size(); ++i4) {
                arrayList.add(list.get(i4));
            }
        }
        return arrayList;
    }

    private List f(List list) {
        ArrayList arrayList = new ArrayList();
        if (list.isEmpty()) {
            return arrayList;
        }
        if (this.enumerationLiterals.contains(list.get(0)) && this.a <= this.enumerationLiterals.size()) {
            for (int i2 = 0; i2 < this.enumerationLiterals.size(); ++i2) {
                arrayList.add(list.get(i2));
            }
        } else if (this.enumerationLiterals.contains(list.get(list.size() - 1)) && this.a >= list.size() - this.enumerationLiterals.size()) {
            for (int i3 = 0; i3 < this.enumerationLiterals.size(); ++i3) {
                arrayList.add(0, list.get(list.size() - 1 - i3));
            }
        } else {
            for (int i4 = 0; i4 < list.size(); ++i4) {
                arrayList.add(list.get(i4));
            }
        }
        return arrayList;
    }

    protected void synchronizePresentations(Element element) {
    }

    private static /* synthetic */ boolean a(Property property, Constraint constraint) {
        return constraint.getConstrainedElements().contains(property);
    }
}

