/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.dc.Point;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Pnt2d;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.LineConstraint;
import net.astah.notation.NotationFactory;
import net.astah.notation.edit.command.Notations;
import net.astah.notation.mindmap.MMDiagram;
import net.astah.notation.mindmap.MMLinkEdge;
import net.astah.notation.mindmap.MMTopicShape;
import net.astah.notation.mindmap.edit.layout.MMLinkEdgeOperations;
import net.astah.notation.util.NotationGetPointsHelper;
import org.eclipse.emf.common.util.EList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModMMLinkEdgePntsCommand
extends Command {
    protected MMLinkEdge linkEdge = null;
    protected Pnt2d[] pnts = null;
    protected double sx;
    protected double sy;
    protected double tx;
    protected double ty;
    protected MMTopicShape sourceTopic = null;
    protected MMTopicShape targetTopic = null;
    protected String changeMMLinkType;
    private static final Logger a = LoggerFactory.getLogger(ModMMLinkEdgePntsCommand.class);

    public void setLinkEdge(MMLinkEdge mMLinkEdge) {
        this.linkEdge = mMLinkEdge;
    }

    public void setPoints(Pnt2d[] pnt2dArray) {
        this.pnts = pnt2dArray;
    }

    public void setSourceEnd(double d2, double d3) {
        this.sx = d2;
        this.sy = d3;
    }

    public void setTargetEnd(double d2, double d3) {
        this.tx = d2;
        this.ty = d3;
    }

    public void setSourceTopic(MMTopicShape mMTopicShape) {
        this.sourceTopic = mMTopicShape;
    }

    public void setTargetTopic(MMTopicShape mMTopicShape) {
        this.targetTopic = mMTopicShape;
    }

    public void setChangeMMLinkType(String string) {
        this.changeMMLinkType = string;
    }

    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            if (this.linkEdge == null || !iJomtEntityStore.contains(this.linkEdge)) {
                return;
            }
            DiagramElement diagramElement = this.linkEdge.getOwningElement();
            if (!(diagramElement instanceof MMDiagram) || diagramElement == null) {
                return;
            }
            Diagram diagram = (Diagram)diagramElement;
            if (!iJomtEntityStore.contains(diagram)) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                if (this.sourceTopic != null || this.targetTopic != null) {
                    if (this.a()) {
                        iJomtEntityStore.abortTransaction();
                        return;
                    }
                    this.a(this.linkEdge);
                }
                if (this.pnts != null) {
                    ModMMLinkEdgePntsCommand.changeInclination(this.linkEdge, this.changeMMLinkType, Geometries.toPoint(this.pnts[0]));
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
            iJomtEntityStore.abortTransaction();
        }
    }

    private boolean a() {
        MMTopicShape mMTopicShape = this.linkEdge.getSourceTopic();
        MMTopicShape mMTopicShape2 = this.linkEdge.getTargetTopic();
        if (this.sourceTopic != null) {
            mMTopicShape = this.sourceTopic;
        }
        if (this.targetTopic != null) {
            mMTopicShape2 = this.targetTopic;
        }
        return mMTopicShape == mMTopicShape2;
    }

    void a(MMLinkEdge mMLinkEdge) {
        if (this.sourceTopic != null) {
            mMLinkEdge.setSourceTopic(this.sourceTopic);
        }
        if (this.targetTopic != null) {
            mMLinkEdge.setTargetTopic(this.targetTopic);
        }
        Notations.setSourceAnchor(mMLinkEdge, NotationFactory.eINSTANCE.createRatioAnchor(this.sx, this.sy));
        Notations.setTargetAnchor(mMLinkEdge, NotationFactory.eINSTANCE.createRatioAnchor(this.tx, this.ty));
        LineConstraint lineConstraint = mMLinkEdge.getLine();
        if (lineConstraint != null) {
            ((EList)NotationGetPointsHelper.INSTANCE.doSwitch(lineConstraint)).clear();
        }
    }

    public static void changeInclination(MMLinkEdge mMLinkEdge, String string, Point point) {
        if ("start".equals(string)) {
            Notations.setSourceAnchor(mMLinkEdge, MMLinkEdgeOperations.getNewEndPnt(point, mMLinkEdge.getSourceTopic()));
            Point point2 = MMLinkEdgeOperations.getNewInclination(point, new LayoutCalculator().getSourceEndPoint(mMLinkEdge, null));
            Notations.setLocation(mMLinkEdge, 0, point2);
        } else if ("end".equals(string)) {
            Notations.setTargetAnchor(mMLinkEdge, MMLinkEdgeOperations.getNewEndPnt(point, mMLinkEdge.getTargetTopic()));
            Point point3 = MMLinkEdgeOperations.getNewInclination(point, new LayoutCalculator().getTargetEndPoint(mMLinkEdge, null));
            Notations.setLocation(mMLinkEdge, 1, point3);
        }
    }
}

