/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import net.astah.jomt.jcontrol.JudeToImageCommand;
import net.astah.jomt.jutil.JomtFileFilter;

public class JudeToPngCommand
extends JudeToImageCommand {
    @Override
    protected String getFormatName() {
        return "png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(BufferedImage bufferedImage, Graphics graphics, FileOutputStream fileOutputStream) throws IOException {
        try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(fileOutputStream);){
            ImageWriter imageWriter = null;
            ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
            Iterator<ImageWriter> iterator = ImageIO.getImageWriters(imageTypeSpecifier, this.getFormatName());
            if (!iterator.hasNext()) {
                throw new IllegalStateException();
            }
            imageWriter = iterator.next();
            IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, null);
            String string = iIOMetadata.getNativeMetadataFormatName();
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(string);
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("pHYs");
            iIOMetadataNode2.setAttribute("pixelsPerUnitXAxis", Integer.toString((int)(this.exportDPI * 100.0 / 2.54 + 0.5)));
            iIOMetadataNode2.setAttribute("pixelsPerUnitYAxis", Integer.toString((int)(this.exportDPI * 100.0 / 2.54 + 0.5)));
            iIOMetadataNode2.setAttribute("unitSpecifier", "meter");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadata.setFromTree(string, iIOMetadataNode);
            imageWriter.setOutput(imageOutputStream);
            IIOImage iIOImage = new IIOImage(bufferedImage, null, iIOMetadata);
            imageWriter.write(null, iIOImage, null);
        }
    }

    @Override
    protected String addExtention(String string) {
        if (!string.endsWith(".png") && !string.endsWith(".PNG")) {
            string = string + ".png";
        }
        return string;
    }

    @Override
    protected boolean withBackground() {
        return true;
    }

    @Override
    protected int getImageType() {
        return 2;
    }

    protected String[] getFileFilterFirstName() {
        return new String[]{"png"};
    }

    protected String getFileFilterSecondName() {
        return "PNG image file";
    }

    @Override
    protected JomtFileFilter getFileFilter() {
        JomtFileFilter jomtFileFilter = new JomtFileFilter(new String[]{"png"}, "PNG image file");
        return jomtFileFilter;
    }

    @Override
    protected Graphics2D getGraphics(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, BufferedImage bufferedImage, OutputStream outputStream) {
        return bufferedImage.createGraphics();
    }

    @Override
    protected BufferedImage getImage(int n2, int n3, double d2) {
        return new BufferedImage((int)((double)n2 * d2), (int)((double)n3 * d2), this.getImageType());
    }

    @Override
    protected void drawImage(BufferedImage bufferedImage, Graphics2D graphics2D, double d2) {
    }
}

