/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.jomt.jcontrol.JudeToImageCommand;
import net.astah.jomt.jutil.JomtFileFilter;
import org.w3c.dom.Element;

public class JudeToJpegCommand
extends JudeToImageCommand {
    @Override
    protected String getFormatName() {
        return "jpg";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(BufferedImage bufferedImage, Graphics graphics, FileOutputStream fileOutputStream) throws IOException {
        try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(fileOutputStream);){
            ImageWriter imageWriter = null;
            ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromRenderedImage(bufferedImage);
            Iterator<ImageWriter> iterator = ImageIO.getImageWriters(imageTypeSpecifier, this.getFormatName());
            if (!iterator.hasNext()) {
                throw new IllegalStateException();
            }
            imageWriter = iterator.next();
            IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(imageTypeSpecifier, null);
            String string = iIOMetadata.getNativeMetadataFormatName();
            IIOMetadataNode iIOMetadataNode = (IIOMetadataNode)iIOMetadata.getAsTree(string);
            Element element = (Element)iIOMetadataNode.getElementsByTagName("app0JFIF").item(0);
            element.setAttribute("Xdensity", Integer.toString((int)this.exportDPI));
            element.setAttribute("Ydensity", Integer.toString((int)this.exportDPI));
            iIOMetadata.setFromTree(string, iIOMetadataNode);
            JPEGImageWriteParam jPEGImageWriteParam = (JPEGImageWriteParam)imageWriter.getDefaultWriteParam();
            jPEGImageWriteParam.setCompressionMode(2);
            jPEGImageWriteParam.setCompressionQuality(this.a());
            imageWriter.setOutput(imageOutputStream);
            IIOImage iIOImage = new IIOImage(bufferedImage, null, iIOMetadata);
            imageWriter.write(null, iIOImage, null);
        }
    }

    private float a() {
        double d2;
        String string = RuntimeGlobal.sysProp.getDefaultString("basic.image_jpeg_export_quality");
        try {
            d2 = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            d2 = 0.75;
        }
        return (float)d2;
    }

    @Override
    protected String addExtention(String string) {
        if (!(string.endsWith(".jpeg") || string.endsWith(".jpg") || string.endsWith(".JPEG") || string.endsWith(".JPG"))) {
            string = string + ".jpg";
        }
        return string;
    }

    @Override
    protected boolean withBackground() {
        return true;
    }

    @Override
    protected int getImageType() {
        return 1;
    }

    protected String[] getFileFilterFirstName() {
        return new String[]{"jpeg", "jpg"};
    }

    protected String getFileFilterSecondName() {
        return "JPEG image file";
    }

    @Override
    protected JomtFileFilter getFileFilter() {
        JomtFileFilter jomtFileFilter = new JomtFileFilter(new String[]{"jpeg", "jpg"}, "JPEG image file");
        return jomtFileFilter;
    }

    @Override
    protected Graphics2D getGraphics(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, BufferedImage bufferedImage, OutputStream outputStream) {
        return bufferedImage.createGraphics();
    }

    @Override
    protected BufferedImage getImage(int n2, int n3, double d2) {
        return new BufferedImage((int)((double)n2 * d2), (int)((double)n3 * d2), this.getImageType());
    }

    @Override
    protected void drawImage(BufferedImage bufferedImage, Graphics2D graphics2D, double d2) {
    }
}

