/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.provider.LabelProviders;
import net.astah.golf.control.Command;
import net.astah.golf.draw.GCamera;
import net.astah.golf.draw.GGraphics;
import net.astah.golf.draw.GImage;
import net.astah.golf.draw.GNode;
import net.astah.golf.draw.GRimmedGeometry;
import net.astah.golf.draw.GText;
import net.astah.golf.emf.EMFGraphics2D;
import net.astah.golf.geom2D.Rectangle2d;
import net.astah.golf.util.Debug;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.swing.UIViewPeer;
import net.astah.golf.widget.CComponent;
import net.astah.golf.widget.CDesktopPane;
import net.astah.golf.widget.swing.SwingCanvas;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.golf.widget.swing.SwingGraphics;
import net.astah.golf.widget.swing.SwingGraphics2D;
import net.astah.golf.widget.swing.SwingImageIcon;
import net.astah.golf.widget.swing.SwingTable;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.DiagramViewInfo;
import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.MMTopicPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UsagePresentation;
import net.astah.jomt.jcontrol.D;
import net.astah.jomt.jcontrol.ToImageUtil;
import net.astah.jomt.jcontrol.UndoCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.FontManager;
import net.astah.jomt.jutil.ImageUtil;
import net.astah.jomt.jutil.JomtFileFilter;
import net.astah.jomt.jutil.MacFilenameFilter;
import net.astah.jomt.jutil.PathUtil;
import net.astah.jomt.jutil.RubberUtilities;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.FileChooserFactory;
import net.astah.jomt.jview.JomtCanvas;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.MultiChooser;
import net.astah.jomt.jview.MultiDiagramChooser;
import net.astah.jomt.jview.TableEditor;
import net.astah.jomt.jview.TableEditorPeer;
import net.astah.jomt.jviewElement.JomtViewElement;
import net.astah.model.operations.DiagramOperations;
import net.astah.notation.TableView;
import net.astah.notation.mindmap.MMDiagramElement;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.UseCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JudeToImageCommand
extends Command {
    protected boolean multi = false;
    protected List diagrams;
    protected String userDir;
    private boolean a = true;
    private boolean b = true;
    private Map c = new HashMap();
    private Editor[] d = null;
    protected double exportDPI = 72.0;
    protected double exportScale = this.exportDPI / 72.0;
    private boolean e = false;
    private boolean f = true;
    private boolean g = false;
    private boolean h = false;
    private boolean i = false;
    private double j = -1.0;
    private double k = -1.0;
    private String l;
    private boolean m = false;
    private static final Logger n = LoggerFactory.getLogger(JudeToImageCommand.class);

    public void setEditors(Editor[] editorArray) {
        this.d = editorArray;
    }

    public void setDiagrams(List list) {
        this.diagrams = list;
    }

    public void setUserDir(String string) {
        this.userDir = string;
    }

    @Override
    public void setArgumentString(String string) {
        if (string != null && string.equalsIgnoreCase("multi")) {
            this.multi = true;
        }
    }

    public boolean isShowDialog() {
        return this.f;
    }

    public void setShowDialog(boolean bl) {
        this.f = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        this.a();
        Debug.taskOver = false;
        try {
            RubberUtilities.setImageMode(true);
            if (!this.isSupportFormat()) {
                return;
            }
            if (this.multi) {
                this.c.clear();
                if (this.diagrams == null) {
                    JFrame jFrame = (JFrame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
                    MultiChooser multiChooser = this.getChooser(jFrame);
                    multiChooser.setSize(600, 500);
                    multiChooser.setLocationRelativeTo(jFrame);
                    multiChooser.setVisible(true);
                    if (!multiChooser.isApprove()) {
                        return;
                    }
                    this.diagrams = multiChooser.getCheckedItems();
                }
                if (this.diagrams.isEmpty()) {
                    return;
                }
                if (this.userDir == null || this.userDir.equals("")) {
                    this.userDir = this.getUserDir();
                }
                if (this.userDir.equals("")) {
                    return;
                }
                if (this.isResized()) {
                    this.resizeFonts();
                }
                for (MultiChooser multiChooser : this.diagrams) {
                    Editor editor;
                    SwingGraphics.resetPreScale();
                    if (!(multiChooser instanceof Diagram)) continue;
                    Diagram diagram = (Diagram)((Object)multiChooser);
                    if (diagram instanceof TableView) {
                        editor = this.createMatrixEditor(diagram);
                        this.outputImageFile(editor, this.userDir);
                        ((TableEditor)editor).remove();
                        continue;
                    }
                    editor = this.createEditor(diagram);
                    this.outputImageFile((DiagramEditor)editor, this.userDir);
                    ((DiagramEditor)editor).remove();
                }
            } else {
                if (this.d == null) {
                    this.d = new Editor[1];
                    this.d[0] = JomtGlobal.viewManager.getCurrentEditor();
                }
                if (this.d[0] == null) {
                    return;
                }
                if (this.d.length == 1) {
                    if (this.d[0] instanceof DiagramEditor) {
                        this.outputImageFile((DiagramEditor)this.d[0], null);
                    } else {
                        this.outputImageFile(this.d[0], null);
                    }
                } else {
                    this.outputImageFile((DiagramEditor)this.d[0], (DiagramEditor)this.d[1], null);
                }
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            if (this.f) {
                MessageManager.displayErrorMessage("app", "out_of_memory.message");
            }
            this.i = true;
        }
        finally {
            Debug.taskOver = true;
            RubberUtilities.setImageMode(false);
        }
    }

    protected void resizeFonts() {
        if (GraphicsEnvironment.isHeadless()) {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            Iterator<EObject> iterator = iJomtEntityStore.entityIterator();
            double d2 = 1.0;
            iJomtEntityStore.beginTransaction();
            while (iterator.hasNext()) {
                double d3;
                EObject eObject = iterator.next();
                if (!(eObject instanceof LabelPresentation)) continue;
                LabelPresentation labelPresentation = (LabelPresentation)eObject;
                Rectangle2d rectangle2d = labelPresentation.getBoundsRect();
                labelPresentation.resize();
                Rectangle2d rectangle2d2 = labelPresentation.getBoundsRect();
                boolean bl = rectangle2d.equals(rectangle2d2);
                if (bl || !((d3 = rectangle2d.width / rectangle2d2.width) < d2)) continue;
                d2 = d3;
            }
            iJomtEntityStore.commitTransaction();
            this.callCommand(new UndoCommand());
            iJomtEntityStore.beginTransaction();
            FontManager.sizeRatio = d2;
            FontManager.resizeFonts();
            this.labelResize(iJomtEntityStore);
            iJomtEntityStore.commitTransaction();
        }
    }

    protected void labelResize(IJomtEntityStore iJomtEntityStore) {
        Iterator<EObject> iterator = iJomtEntityStore.entityIterator();
        while (iterator.hasNext()) {
            EObject eObject = iterator.next();
            if (!(eObject instanceof LabelPresentation) || !(eObject instanceof LabelPresentation)) continue;
            LabelPresentation labelPresentation = (LabelPresentation)eObject;
            labelPresentation.resize();
        }
    }

    private void a(MMTopicPresentation mMTopicPresentation) {
        mMTopicPresentation.setFixHorizontalPosition(true);
        mMTopicPresentation.updateLabelFontHeight();
        mMTopicPresentation.resize();
        List<MMTopicPresentation> list = mMTopicPresentation.getChildren();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MMTopicPresentation mMTopicPresentation2 = list.get(i2);
            this.a(mMTopicPresentation2);
        }
    }

    private void a() {
        String string;
        double d2;
        String string2;
        if (this.k > 0.0) {
            this.exportDPI = this.k;
        } else {
            if (this.j != -1.0) {
                this.exportDPI = this.j;
                this.exportScale = this.exportDPI / 72.0;
                return;
            }
            string2 = RuntimeGlobal.sysProp.getStringWithDefault("basic.image_export_dpi");
            try {
                this.exportDPI = Double.valueOf(string2);
            }
            catch (NumberFormatException numberFormatException) {
                string2 = RuntimeGlobal.sysProp.getDefaultString("basic.image_export_dpi");
                this.exportDPI = Double.valueOf(string2);
            }
        }
        string2 = RuntimeGlobal.sysProp.getDefaultString("basic.image_export_dpi_minimum");
        double d3 = Double.valueOf(string2);
        if (this.exportDPI < d3) {
            this.exportDPI = d3;
        }
        if (this.exportDPI > (d2 = Double.valueOf(string = RuntimeGlobal.sysProp.getDefaultString("basic.image_export_dpi_maximum")).doubleValue())) {
            this.exportDPI = d2;
        }
        this.exportScale = this.exportDPI / 72.0;
    }

    protected boolean isSupportFormat() {
        boolean bl = false;
        String string = this.getFormatName();
        String[] stringArray = ImageIO.getWriterFormatNames();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected String getUserDir() {
        String string = this.c();
        JFileChooser jFileChooser = FileChooserFactory.createJFileChooser(string);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setApproveButtonToolTipText(PropertyManager.getProjectViewResourceBundle().getString("ui.dialog.select_directory.tooltip"));
        Component component = ((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
        if (jFileChooser.showDialog(component, PropertyManager.getProjectViewResourceBundle().getString("ui.button.select.label")) != 0) {
            return "";
        }
        File file = jFileChooser.getSelectedFile();
        string = file.getAbsolutePath() + File.separator;
        RuntimeGlobal.sysProp.setString("image.path", file.getAbsolutePath());
        return string;
    }

    protected MultiChooser getChooser(JFrame jFrame) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("jude.usecaseDescritpion.support");
        MultiDiagramChooser multiDiagramChooser = new MultiDiagramChooser(jFrame, true, bl, true);
        multiDiagramChooser.setTitle(this.getTitle("ui.dialog.multi_image_diagram_chooser.title"));
        return multiDiagramChooser;
    }

    protected String getTitle(String string) {
        String string2 = PropertyManager.getProjectViewResourceBundle().getString(string);
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    public DiagramEditor createEditor(Diagram diagram) {
        DiagramViewInfo diagramViewInfo = new DiagramViewInfo(diagram, new GCamera());
        CDesktopPane cDesktopPane = JomtGlobal.viewManager.getManagementView().getDesktopPane();
        DiagramEditor diagramEditor = new DiagramEditor(diagramViewInfo, cDesktopPane, false);
        return diagramEditor;
    }

    protected TableEditor createMatrixEditor(Diagram diagram) {
        CDesktopPane cDesktopPane = JomtGlobal.viewManager.getManagementView().getDesktopPane();
        D d2 = new D(this, diagram, cDesktopPane);
        d2.maximize();
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputImageFile(Editor editor, String string) {
        Object object;
        File file;
        double d2;
        double d3;
        UIViewPeer uIViewPeer = editor.getUiViewPeer();
        JTable jTable = null;
        Rectangle2D rectangle2D = null;
        if (uIViewPeer instanceof TableEditorPeer) {
            jTable = (JTable)((SwingTable)((TableEditorPeer)uIViewPeer).getTable()).getComponent();
            rectangle2D = jTable.getBounds();
            d3 = rectangle2D.getWidth();
            d2 = rectangle2D.getHeight() + jTable.getTableHeader().getPreferredSize().getHeight();
            if (d3 == 0.0) {
                d3 = jTable.getTableHeader().getPreferredSize().getWidth();
            }
        } else {
            return;
        }
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getWidth(), d3, d2);
        rectangle2D = this.adjustPresentationRect(rectangle2D);
        int n2 = (int)rectangle2D.getWidth();
        int n3 = (int)rectangle2D.getHeight();
        String string2 = this.getImageName(editor);
        if (string2 == null) {
            return;
        }
        this.l = string2;
        if (this.multi) {
            string2 = string + string2;
            file = new File(string2);
            object = file.getParentFile();
            if (!((File)object).exists()) {
                ((File)object).mkdirs();
            }
            if (((File)object).exists() && ((File)object).isFile()) {
                this.l = null;
                return;
            }
        }
        try {
            file = new File(string2);
            if (!PathUtil.isLegalFileName(file.getName())) {
                MessageManager.displayErrorMessage("app", "tell_save_fail_illegal_file_name.message");
                this.l = null;
                return;
            }
            if (file.exists() && !file.canWrite()) {
                MessageManager.displayAlertMessageDialog("app", "read_only.message");
                return;
            }
            if (file.exists() && this.b()) {
                file.renameTo(new File(string2 + ".bak"));
            }
            n.info("file: {}", (Object)string2);
            object = null;
            try {
                object = new FileOutputStream(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.l = null;
                MessageManager.displayAlertMessageDialog("app", "tell_save_fail.message");
            }
            catch (Error error) {
                this.l = null;
                MessageManager.displayAlertMessageDialog("app", "save_image_failure.message");
            }
            jTable.setRowSelectionAllowed(false);
            if (uIViewPeer instanceof TableEditorPeer) {
                jTable.setColumnSelectionAllowed(false);
            }
            BufferedImage bufferedImage = this.getImage(n2, n3, this.exportScale);
            Graphics2D graphics2D = this.getGraphics(rectangle2D, rectangle2D, bufferedImage, (OutputStream)object);
            this.drawBackground(null, graphics2D, n2, n3, this.exportScale);
            if (uIViewPeer instanceof TableEditorPeer) {
                bufferedImage = this.a(jTable, rectangle2D);
                this.drawImage(bufferedImage, graphics2D, this.getExportScale());
            }
            try {
                this.encode(bufferedImage, graphics2D, (FileOutputStream)object);
                ((FileOutputStream)object).close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.l = null;
                MessageManager.displayAlertMessageDialog("app", "tell_save_fail.message");
            }
            catch (IOException iOException) {
                this.l = null;
                n.error("error has occurred.", iOException);
            }
            catch (Error error) {
                this.l = null;
                MessageManager.displayAlertMessageDialog("app", "save_image_failure.message");
            }
        }
        catch (Exception exception) {
            this.l = null;
            n.error("error has occurred.", exception);
        }
        finally {
            jTable.setRowSelectionAllowed(true);
            if (uIViewPeer instanceof TableEditorPeer) {
                jTable.setColumnSelectionAllowed(true);
            }
        }
    }

    private Image a(JComponent jComponent) {
        int n2 = jComponent.getBounds().width;
        int n3 = jComponent.getBounds().height;
        if (n2 == 0) {
            n2 = 1;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics graphics = ((Image)bufferedImage).getGraphics();
        jComponent.paint(graphics);
        return bufferedImage;
    }

    protected void drawImage(Image image, Graphics2D graphics2D) {
        GImage gImage = new GImage(new SwingImageIcon(new ImageIcon(image)));
        GGraphics gGraphics = new GGraphics(new SwingGraphics2D(graphics2D));
        gGraphics.setColorMap(JomtViewElement.DEFAULT_COLOR_MAP);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
        gImage.draw(gGraphics);
    }

    private BufferedImage a(JTable jTable) {
        int n2 = jTable.getTableHeader().getBounds().height;
        int n3 = (int)jTable.getTableHeader().getPreferredSize().getWidth();
        int n4 = n2 + jTable.getBounds().height;
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, bufferedImage.getWidth(null), bufferedImage.getHeight(null));
        Image image = this.a(jTable.getTableHeader());
        graphics.drawImage(image, 0, 0, null);
        image = this.a((JComponent)jTable);
        graphics.drawImage(image, 0, n2, null);
        if (graphics instanceof Graphics2D) {
            this.a((Graphics2D)graphics, n3, n4);
        }
        return bufferedImage;
    }

    private BufferedImage a(JTable jTable, Rectangle2D rectangle2D) {
        Object object;
        int n2 = (int)rectangle2D.getWidth();
        int n3 = (int)rectangle2D.getHeight();
        if (GraphicsEnvironment.isHeadless()) {
            object = jTable.getParent().getParent();
            ((Container)object).addNotify();
            ((Component)object).setSize(new Dimension(n2, n3));
            ((Container)object).validate();
        }
        object = new BufferedImage(n2, n3, 1);
        Graphics graphics = ((BufferedImage)object).getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, ((BufferedImage)object).getWidth(null), ((BufferedImage)object).getHeight(null));
        Image image = this.a(jTable.getTableHeader());
        graphics.drawImage(image, 0, 0, null);
        image = this.a((JComponent)jTable);
        graphics.drawImage(image, 0, (int)jTable.getTableHeader().getPreferredSize().getHeight(), null);
        if (graphics instanceof Graphics2D) {
            this.a((Graphics2D)graphics, n2, n3);
        }
        return object;
    }

    private BufferedImage b(JTable jTable) {
        Object object;
        int n2 = jTable.getTableHeader().getPreferredSize().height;
        int n3 = jTable.getPreferredSize().width;
        int n4 = n2 + jTable.getPreferredSize().height;
        if (GraphicsEnvironment.isHeadless()) {
            object = jTable.getParent().getParent();
            ((Container)object).addNotify();
            ((Component)object).setSize(new Dimension(n3, n4));
            ((Container)object).validate();
        }
        object = new BufferedImage(n3, n4, 1);
        Graphics graphics = ((BufferedImage)object).getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, ((BufferedImage)object).getWidth(null), ((BufferedImage)object).getHeight(null));
        Image image = this.a(jTable.getTableHeader());
        graphics.drawImage(image, 0, 0, null);
        image = this.a((JComponent)jTable);
        graphics.drawImage(image, 0, n2, null);
        if (graphics instanceof Graphics2D) {
            this.a((Graphics2D)graphics, n3, n4);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void outputImageFile(DiagramEditor diagramEditor, String string) {
        JomtCanvas jomtCanvas;
        block38: {
            Object object;
            Object object2;
            Object object3;
            String string2;
            Rectangle2d rectangle2d;
            int n2;
            int n3;
            double d2;
            double d3;
            Rectangle2D rectangle2D;
            block36: {
                block35: {
                    jomtCanvas = (JomtCanvas)((SwingCanvas)diagramEditor.getCanvas()).getComponent();
                    rectangle2D = ToImageUtil.getRectangle(this.getPresentations(diagramEditor, jomtCanvas));
                    rectangle2D = ToImageUtil.a(rectangle2D, ToImageUtil.getRectangle(this.getMMDiagramElements(diagramEditor, jomtCanvas)));
                    rectangle2D = this.adjustPresentationRect(rectangle2D);
                    d3 = ToImageUtil.getImageX(rectangle2D);
                    d2 = ToImageUtil.getImageY(rectangle2D);
                    n3 = Math.max(ToImageUtil.getImageWidth(rectangle2D), ImageUtil.getWatermarkWidth());
                    n2 = ToImageUtil.getImageHeight(rectangle2D) + ImageUtil.getWatermarkHeight();
                    rectangle2d = new Rectangle2d(d3, d2, n3, n2);
                    string2 = this.getImageName(diagramEditor);
                    if (string2 == null) {
                        return;
                    }
                    this.l = string2;
                    if (this.multi) {
                        string2 = string + string2;
                        object3 = new File(string2);
                        object2 = ((File)object3).getParentFile();
                        if (!((File)object2).exists()) {
                            ((File)object2).mkdirs();
                        }
                        if (((File)object2).exists() && ((File)object2).isFile()) {
                            this.l = null;
                            return;
                        }
                    }
                    object3 = this.a(jomtCanvas);
                    object2 = new File(string2);
                    if (PathUtil.isLegalFileName(((File)object2).getName())) break block35;
                    MessageManager.displayErrorMessage("app", "tell_save_fail_illegal_file_name.message");
                    this.l = null;
                    Iterator iterator = object3.iterator();
                    while (iterator.hasNext()) {
                        GText gText = (GText)iterator.next();
                        gText.setHighlighted(true);
                    }
                    return;
                }
                if (!((File)object2).exists() || ((File)object2).canWrite()) break block36;
                MessageManager.displayAlertMessageDialog("app", "read_only.message");
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    GText gText = (GText)iterator.next();
                    gText.setHighlighted(true);
                }
                return;
            }
            try {
                if (((File)object2).exists() && this.b()) {
                    object = new File(string2 + ".bak");
                    if (((File)object).exists()) {
                        ((File)object).delete();
                    }
                    ((File)object2).renameTo((File)object);
                }
                n.info("file: {}", (Object)string2);
                object = null;
                try {
                    object = new FileOutputStream(string2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.l = null;
                    if (this.f) {
                        MessageManager.displayAlertMessageDialog("app", "tell_save_fail.message");
                    }
                    this.g = true;
                }
                catch (Error error) {
                    this.l = null;
                    if (this.f) {
                        MessageManager.displayAlertMessageDialog("app", "save_image_failure.message");
                    }
                    this.h = true;
                }
                BufferedImage bufferedImage = this.getImage(n3, n2, this.exportScale);
                Graphics2D graphics2D = this.getGraphics(rectangle2d, rectangle2D, bufferedImage, (OutputStream)object);
                Object object4 = object3.iterator();
                while (object4.hasNext()) {
                    GText gText = (GText)object4.next();
                    gText.setHighlighted(false);
                }
                this.hideGrid(diagramEditor);
                this.hideHyperlinkIcon(diagramEditor);
                this.hideMiniIcon(diagramEditor);
                object4 = (GRimmedGeometry)diagramEditor.getDiagramScene().getDiagramViewElement().getBodyNode();
                this.drawBackground((GRimmedGeometry)object4, graphics2D, n3, n2, this.exportScale);
                if (bufferedImage != null) {
                    this.a(graphics2D, bufferedImage.getWidth(), bufferedImage.getHeight());
                }
                try {
                    if (GolfUtilities.isMacRetina()) {
                        graphics2D.scale(0.5, 0.5);
                    }
                    this.drawCanvas(diagramEditor, d3, d2, n3, n2, rectangle2d, graphics2D);
                }
                finally {
                    if (GolfUtilities.isMacRetina()) {
                        graphics2D.scale(2.0, 2.0);
                    }
                }
                this.setHyperlinkIconVisibility(diagramEditor, (GRimmedGeometry)object4);
                this.setMiniIconVisibility(diagramEditor, (GRimmedGeometry)object4);
                this.setGridVisibility(diagramEditor);
                try {
                    this.encode(bufferedImage, graphics2D, (FileOutputStream)object);
                    ((FileOutputStream)object).close();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.l = null;
                    if (this.f) {
                        MessageManager.displayAlertMessageDialog("app", "tell_save_fail.message");
                    }
                    this.g = true;
                }
                catch (IOException iOException) {
                    this.l = null;
                    n.error("error has occurred.", iOException);
                }
                catch (Error error) {
                    this.l = null;
                    if (this.f) {
                        MessageManager.displayAlertMessageDialog("app", "save_image_failure.message");
                    }
                    this.h = true;
                }
                object2 = object3.iterator();
            }
            catch (Exception exception) {
                Iterator iterator;
                try {
                    this.l = null;
                    this.h = true;
                    n.error("error has occurred.", exception);
                    iterator = object3.iterator();
                }
                catch (Throwable throwable) {
                    Iterator<GText> iterator2 = object3.iterator();
                    while (iterator2.hasNext()) {
                        GText gText = iterator2.next();
                        gText.setHighlighted(true);
                    }
                    throw throwable;
                }
                while (iterator.hasNext()) {
                    GText gText = (GText)iterator.next();
                    gText.setHighlighted(true);
                }
                break block38;
            }
            while (object2.hasNext()) {
                object = (GText)object2.next();
                ((GText)object).setHighlighted(true);
            }
        }
        this.unselect(jomtCanvas);
    }

    private List<GText> a(JomtCanvas jomtCanvas) {
        ArrayList<GText> arrayList = new ArrayList<GText>();
        for (GNode gNode : jomtCanvas.getAllNodes()) {
            GText gText;
            if (!(gNode instanceof GText) || !(gText = (GText)gNode).isVisible() || !gText.isHighlighted()) continue;
            arrayList.add(gText);
        }
        return arrayList;
    }

    protected void drawCanvas(DiagramEditor diagramEditor, double d2, double d3, int n2, int n3, Rectangle2d rectangle2d, Graphics2D graphics2D) {
        JomtCanvas jomtCanvas = (JomtCanvas)((SwingCanvas)diagramEditor.getCanvas()).getComponent();
        SwingGraphics2D swingGraphics2D = new SwingGraphics2D(graphics2D);
        jomtCanvas.draw(swingGraphics2D, this.getCameraToSee(d2, d3, n2, n3, this.exportScale), rectangle2d);
    }

    private void a(Graphics2D graphics2D, int n2, int n3) {
        ImageUtil.drawWaterMarkBottomDown(graphics2D, n2, n3);
    }

    protected void outputImageFile(DiagramEditor diagramEditor, DiagramEditor diagramEditor2, String string) {
        int n2 = 20;
        Rectangle2D rectangle2D = this.a(diagramEditor);
        Rectangle2D rectangle2D2 = this.a(diagramEditor2);
        Rectangle2D rectangle2D3 = this.a(rectangle2D, rectangle2D2, n2);
        rectangle2D3 = this.adjustPresentationRect(rectangle2D3);
        int n3 = ToImageUtil.getImageWidth(rectangle2D3);
        int n4 = ToImageUtil.getImageHeight(rectangle2D3);
        String string2 = this.getImageName(diagramEditor);
        if (string2 == null) {
            return;
        }
        try {
            File file = new File(string2);
            if (!PathUtil.isLegalFileName(file.getName())) {
                MessageManager.displayErrorMessage("app", "tell_save_fail_illegal_file_name.message");
                return;
            }
            if (file.exists() && !file.canWrite()) {
                MessageManager.displayAlertMessageDialog("app", "read_only.message");
                return;
            }
            if (file.exists() && this.b()) {
                file.renameTo(new File(string2 + ".bak"));
            }
            n.info("file: {}", (Object)string2);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.f) {
                    MessageManager.displayAlertMessageDialog("app", "tell_save_fail.message");
                }
                this.g = true;
            }
            catch (Error error) {
                if (this.f) {
                    MessageManager.displayAlertMessageDialog("app", "save_image_failure.message");
                }
                this.h = true;
            }
            BufferedImage bufferedImage = this.getImage(n3, n4, this.exportScale);
            Graphics2D graphics2D = this.getGraphics(rectangle2D3, rectangle2D3, bufferedImage, fileOutputStream);
            this.drawBackground(null, graphics2D, n3, n4, this.exportScale);
            this.hideGrid(diagramEditor);
            this.hideGrid(diagramEditor2);
            this.hideHyperlinkIcon(diagramEditor);
            this.hideHyperlinkIcon(diagramEditor2);
            this.hideMiniIcon(diagramEditor);
            this.hideMiniIcon(diagramEditor2);
            this.a(diagramEditor, graphics2D, rectangle2D, this.exportScale);
            if (graphics2D instanceof EMFGraphics2D) {
                ((EMFGraphics2D)graphics2D).translatePositon(this.a(rectangle2D, n2), 0.0);
                graphics2D.setXORMode(Color.WHITE);
            } else {
                graphics2D.translate(this.a(rectangle2D, n2), 0.0);
            }
            this.a(diagramEditor2, graphics2D, rectangle2D2, this.exportScale);
            this.setHyperlinkIconVisibility(diagramEditor, null);
            this.setHyperlinkIconVisibility(diagramEditor2, null);
            this.setMiniIconVisibility(diagramEditor, null);
            this.setMiniIconVisibility(diagramEditor2, null);
            this.setGridVisibility(diagramEditor);
            this.setGridVisibility(diagramEditor2);
            try {
                this.encode(bufferedImage, graphics2D, fileOutputStream);
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.f) {
                    MessageManager.displayAlertMessageDialog("app", "tell_save_fail.message");
                }
                this.g = true;
            }
            catch (IOException iOException) {
                n.error("error has occurred.", iOException);
            }
            catch (Error error) {
                if (this.f) {
                    MessageManager.displayAlertMessageDialog("app", "save_image_failure.message");
                }
                this.h = true;
            }
        }
        catch (Exception exception) {
            n.error("error has occurred.", exception);
        }
    }

    private double a(Rectangle2D rectangle2D, int n2) {
        return (rectangle2D.getWidth() + (double)n2) * this.exportScale;
    }

    private Rectangle2D a(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n2) {
        Rectangle2d rectangle2d = new Rectangle2d();
        double d2 = rectangle2D.getWidth() + rectangle2D2.getWidth() + (double)n2;
        double d3 = rectangle2D.getHeight() > rectangle2D2.getHeight() ? rectangle2D.getHeight() : rectangle2D2.getHeight();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getY() < rectangle2D2.getY() ? rectangle2D.getY() : rectangle2D2.getY();
        ((Rectangle2D)rectangle2d).setRect(d4, d5, d2, d3);
        return rectangle2d;
    }

    private void a(DiagramEditor diagramEditor, Graphics2D graphics2D, Rectangle2D rectangle2D, double d2) {
        JomtCanvas jomtCanvas = (JomtCanvas)((SwingCanvas)diagramEditor.getCanvas()).getComponent();
        SwingGraphics2D swingGraphics2D = new SwingGraphics2D(graphics2D);
        jomtCanvas.draw(swingGraphics2D, this.getCameraToSee(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight(), d2), (Rectangle2d)rectangle2D);
    }

    private Rectangle2D a(DiagramEditor diagramEditor) {
        ArrayList<Presentation> arrayList = Lists.newArrayList(Iterables.filter(diagramEditor.getDiagram().getOwnedElements(), Presentation.class));
        DiagramElement[] diagramElementArray = arrayList.toArray(new Presentation[0]);
        return ToImageUtil.getRectangle(diagramElementArray);
    }

    public void outputImageFile(BufferedImage bufferedImage) {
        String string = this.getImageName(null);
        if (string == null) {
            return;
        }
        try {
            File file = new File(string);
            if (!PathUtil.isLegalFileName(file.getName())) {
                MessageManager.displayErrorMessage("app", "tell_save_fail_illegal_file_name.message");
                return;
            }
            if (file.exists() && !file.canWrite()) {
                MessageManager.displayAlertMessageDialog("app", "read_only.message");
                return;
            }
            if (file.exists() && this.b()) {
                file.renameTo(new File(string + ".bak"));
            }
            FileOutputStream fileOutputStream = null;
            n.info("file: {}", (Object)string);
            try {
                fileOutputStream = new FileOutputStream(string);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.f) {
                    MessageManager.displayAlertMessageDialog("app", "tell_save_fail.message");
                }
                this.g = true;
            }
            catch (Error error) {
                if (this.f) {
                    MessageManager.displayAlertMessageDialog("app", "save_image_failure.message");
                }
                this.h = true;
            }
            Rectangle2D rectangle2D = new Rectangle2D.Double();
            rectangle2D.setRect(10.0, 10.0, bufferedImage.getWidth() - 20, bufferedImage.getHeight() - 20);
            rectangle2D = this.adjustPresentationRect(rectangle2D);
            this.getImage((int)rectangle2D.getWidth() + 20, (int)rectangle2D.getHeight() + 20, this.exportScale);
            Graphics2D graphics2D = this.getGraphics(rectangle2D, rectangle2D, bufferedImage, fileOutputStream);
            this.drawImage(bufferedImage, graphics2D, this.exportScale);
            try {
                this.encode(bufferedImage, graphics2D, fileOutputStream);
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.f) {
                    MessageManager.displayAlertMessageDialog("app", "tell_save_fail.message");
                }
            }
            catch (IOException iOException) {
                n.error("error has occurred.", iOException);
            }
            catch (Error error) {
                if (this.f) {
                    MessageManager.displayAlertMessageDialog("app", "save_image_failure.message");
                }
                this.h = true;
            }
        }
        catch (Exception exception) {
            n.error("error has occurred.", exception);
        }
    }

    protected void drawImage(BufferedImage bufferedImage, Graphics2D graphics2D, double d2) {
        GImage gImage = new GImage(new SwingImageIcon(new ImageIcon(bufferedImage)));
        GGraphics gGraphics = new GGraphics(new SwingGraphics2D(graphics2D));
        gGraphics.setColorMap(JomtViewElement.DEFAULT_COLOR_MAP);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, (int)((double)bufferedImage.getWidth() * d2), (int)((double)bufferedImage.getHeight() * d2));
        gImage.draw(gGraphics);
    }

    protected GCamera getCameraToSee(double d2, double d3, double d4, double d5, double d6) {
        return JomtCanvas.getCameraToSee(d2, d3, d4, d5, d6);
    }

    protected Rectangle2D adjustPresentationRect(Rectangle2D rectangle2D) {
        return rectangle2D;
    }

    protected void setGridVisibility(DiagramEditor diagramEditor) {
        boolean bl = RuntimeGlobal.sysProp.getBoolean("grid.diagram_visibility");
        diagramEditor.getDiagramViewInfo().setGridMode(bl);
        diagramEditor.getDiagramScene().getDiagramViewElement().getDgmGrid().setVisible(bl);
    }

    protected void hideGrid(DiagramEditor diagramEditor) {
        boolean bl = RuntimeGlobal.sysProp.getBoolean("grid.diagram_visibility");
        if (bl) {
            boolean bl2 = RuntimeGlobal.sysProp.getBoolean("grid.export.image_visibility");
            diagramEditor.getDiagramViewInfo().setGridMode(bl2);
            diagramEditor.getDiagramScene().getDiagramViewElement().getDgmGrid().setVisible(bl2);
        }
    }

    protected void drawBackground(GRimmedGeometry gRimmedGeometry, Graphics2D graphics2D, int n2, int n3, double d2) {
        if (!this.withBackground()) {
            gRimmedGeometry.setAlpha(0.0f);
        } else {
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, (int)((double)n2 * d2), (int)((double)n3 * d2));
        }
    }

    protected void hideHyperlinkIcon(DiagramEditor diagramEditor) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("hyperlink.diagram_icon_image_visibility");
        if (!bl) {
            this.a(diagramEditor, false);
        }
    }

    protected void setHyperlinkIconVisibility(DiagramEditor diagramEditor, GRimmedGeometry gRimmedGeometry) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("hyperlink.diagram_icon_visibility");
        this.a(diagramEditor, bl);
        if (!this.withBackground()) {
            gRimmedGeometry.setAlpha(1.0f);
        }
    }

    protected void hideMiniIcon(DiagramEditor diagramEditor) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("mini_icon.diagram_icon_image_visibility");
        if (!bl) {
            this.b(diagramEditor, false);
        }
    }

    protected void setMiniIconVisibility(DiagramEditor diagramEditor, GRimmedGeometry gRimmedGeometry) {
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("mini_icon.diagram_icon_visibility");
        this.b(diagramEditor, bl);
        if (!this.withBackground()) {
            gRimmedGeometry.setAlpha(1.0f);
        }
    }

    private boolean b() {
        return RuntimeGlobal.sysProp.getBooleanWithDefault("file.create_backup_file_image_file");
    }

    private String c() {
        String string = RuntimeGlobal.sysProp.getStringWithDefault("image.path");
        if (string == null || string.equals("")) {
            string = JomtGlobal.getDeskTopDir();
        }
        return string;
    }

    protected String getImageName(Editor editor) {
        int n2;
        Object object;
        Serializable serializable;
        if (this.multi) {
            if (editor instanceof TableEditor) {
                return this.getSingleImageName(((TableEditor)editor).getModel());
            }
            return this.getSingleImageName(((DiagramEditor)editor).getDiagram());
        }
        String string = this.c();
        File file = null;
        String string2 = "";
        String string3 = "";
        if (editor instanceof TableEditor) {
            string3 = ((TableEditor)editor).getEditorTitle();
        } else if (editor != null) {
            string3 = ((DiagramEditor)editor).getDiagram().getName();
        }
        string3 = PathUtil.getLegalFileName(string3);
        if (PropertyManager.isMacOS()) {
            serializable = (Frame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
            object = new FileDialog((Frame)serializable);
            ((FileDialog)object).setMode(1);
            MacFilenameFilter macFilenameFilter = new MacFilenameFilter();
            String string4 = this.getFormatName();
            if (string4.equals("png")) {
                macFilenameFilter.setPNG(true);
            } else if (string4.equals("jpg")) {
                macFilenameFilter.setJPG(true);
            } else if (string4.equals("emf")) {
                macFilenameFilter.setEMF(true);
            }
            ((FileDialog)object).setFilenameFilter(macFilenameFilter);
            ((FileDialog)object).setDirectory(JomtGlobal.getFileDir());
            ((FileDialog)object).setFile(string3);
            ((Dialog)object).setVisible(true);
            if (((FileDialog)object).getFile() == null) {
                return null;
            }
            file = new File(((FileDialog)object).getDirectory() + ((FileDialog)object).getFile());
            string2 = ((FileDialog)object).getDirectory() + ((FileDialog)object).getFile();
        } else {
            CComponent cComponent;
            serializable = FileChooserFactory.createJFileChooser(string);
            object = this.getFileFilter();
            ((JFileChooser)serializable).addChoosableFileFilter((FileFilter)object);
            ((JFileChooser)serializable).setFileFilter((FileFilter)object);
            if (!"".equals(string3)) {
                ((JFileChooser)serializable).setSelectedFile(new File(string + File.separator + string3));
            }
            if (((JFileChooser)serializable).showSaveDialog(((SwingComponent)(cComponent = JomtGlobal.viewManager.getManagementView().getComponent())).getComponent()) != 0) {
                return null;
            }
            file = ((JFileChooser)serializable).getSelectedFile();
            string2 = file.getAbsolutePath();
        }
        RuntimeGlobal.sysProp.setString("image.path", file.getParent());
        string2 = this.addExtention(string2);
        if (!PathUtil.isLegalFileName(file.getName())) {
            MessageManager.displayAlertMessageDialog("app", "tell_save_fail_illegal_file_name.message");
            return null;
        }
        serializable = new File(string2);
        if (((File)serializable).exists() && (n2 = MessageManager.displayMessageYesNoDialog("app", "ask_overwrite_file.message")) != 0) {
            return null;
        }
        return this.a(string2);
    }

    private String a(String string) {
        String string2 = string.replaceAll("\n", "_");
        return string2;
    }

    protected String getSingleImageName(EObject eObject) {
        String string = LabelProviders.getName(eObject);
        if (this.e) {
            string = EObjects.getID(eObject);
        }
        String string2 = PathUtil.getLegalFileName(string);
        String string3 = this.a(string2);
        String string4 = null;
        String string5 = "";
        if (eObject instanceof Diagram) {
            string5 = this.a((Diagram)eObject);
            string4 = string3;
        } else if (eObject instanceof UseCase) {
            string5 = this.a((UseCase)eObject);
            string4 = string3;
        } else {
            string5 = this.a(eObject);
            string4 = string3;
        }
        if (!this.e) {
            string4 = string5 + string4;
        }
        string4 = this.a(string4, eObject);
        return this.addExtention(string4);
    }

    private String a(String string, EObject eObject) {
        Object v2 = this.c.get(string);
        int n2 = 0;
        while (v2 != null && v2 != eObject) {
            string = string + "_" + String.valueOf(n2);
            v2 = this.c.get(string);
        }
        this.c.put(string, eObject);
        return string;
    }

    private String a(Diagram diagram) {
        if (diagram == null) {
            throw new IllegalArgumentException("diagram is null.");
        }
        String string = LabelProviders.getQualifiedText(DiagramOperations.getParent(diagram));
        if (StringUtils.isEmpty(string)) {
            return "";
        }
        return string.replace("::", File.separator) + File.separator;
    }

    private String a(UseCase useCase) {
        Namespace namespace = this.getValidParent(useCase.getNamespace());
        return this.a(namespace);
    }

    private String a(Namespace namespace) {
        if (!this.a && namespace == EntityAccessor.getProjectModel()) {
            return "";
        }
        String string = PathUtil.getLegalDirectoryName(namespace.getName());
        return this.a((EObject)namespace) + string + File.separator;
    }

    protected Namespace getValidParent(Element element) {
        throw new UnsupportedOperationException("\u672a\u5bfe\u5fdc");
    }

    public void setIncludeRootPackage(boolean bl) {
        this.a = bl;
    }

    public void setSupportClassifier(boolean bl) {
        this.b = bl;
    }

    public Map getDiagramMap() {
        return this.c;
    }

    private String a(EObject eObject) {
        throw new UnsupportedOperationException("\u672a\u5bfe\u5fdc");
    }

    private void a(Editor editor, boolean bl) {
        if (editor instanceof DiagramEditor) {
            List<GNode> list = ((DiagramEditor)editor).getCanvas().getAllNodes();
            for (GNode gNode : list) {
                if (gNode.getType() != 512) continue;
                gNode.setVisible(bl);
            }
        }
    }

    private void b(Editor editor, boolean bl) {
        if (editor instanceof DiagramEditor) {
            List<GNode> list = ((DiagramEditor)editor).getCanvas().getAllNodes();
            for (GNode gNode : list) {
                if (gNode.getType() != 4096) continue;
                gNode.setVisible(bl);
            }
        }
    }

    protected DiagramElement[] getDiagramElements(DiagramEditor diagramEditor, JomtCanvas jomtCanvas) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        arrayList.addAll(Arrays.asList(this.getPresentations(diagramEditor, jomtCanvas)));
        arrayList.addAll(Arrays.asList(this.getMMDiagramElements(diagramEditor, jomtCanvas)));
        return (Presentation[])arrayList.toArray(new DiagramElement[0]);
    }

    protected DiagramElement[] getPresentations(DiagramEditor diagramEditor, JomtCanvas jomtCanvas) {
        ArrayList<DiagramElement> arrayList = Lists.newArrayList();
        for (DiagramElement diagramElement : Lists.newArrayList(DiagramElements.getAllContents(diagramEditor.getDiagram()))) {
            if (diagramElement instanceof ClassifierPresentation) {
                if (!((ClassifierPresentation)diagramElement).isVisibility()) continue;
                arrayList.add(diagramElement);
                continue;
            }
            if (diagramElement instanceof UsagePresentation) {
                if (!((UsagePresentation)diagramElement).isVisibility()) continue;
                arrayList.add(diagramElement);
                continue;
            }
            arrayList.add(diagramElement);
        }
        DiagramElement[] diagramElementArray = arrayList.toArray(new DiagramElement[0]);
        diagramElementArray = ToImageUtil.adjustForFramePs(diagramElementArray);
        return diagramElementArray;
    }

    protected MMDiagramElement[] getMMDiagramElements(DiagramEditor diagramEditor, JomtCanvas jomtCanvas) {
        return Lists.newArrayList(Iterables.filter(diagramEditor.getDiagram().getOwnedElements(), MMDiagramElement.class)).toArray(new MMDiagramElement[0]);
    }

    protected abstract int getImageType();

    protected abstract boolean withBackground();

    protected abstract void encode(BufferedImage var1, Graphics var2, FileOutputStream var3) throws IOException;

    protected abstract String getFormatName();

    protected abstract String addExtention(String var1);

    protected abstract JomtFileFilter getFileFilter();

    protected abstract Graphics2D getGraphics(Rectangle2D var1, Rectangle2D var2, BufferedImage var3, OutputStream var4);

    protected abstract BufferedImage getImage(int var1, int var2, double var3);

    public void setUseIdName(boolean bl) {
        this.e = bl;
    }

    public void setFixedDPI(double d2) {
        this.j = d2;
    }

    public void setDpiParam(double d2) {
        this.k = d2;
    }

    protected double getExportScale() {
        return this.exportScale;
    }

    protected void unselect(JomtCanvas jomtCanvas) {
    }

    public String getExportedFile() {
        return this.l;
    }

    public boolean isFileNotFoundException() {
        return this.g;
    }

    public boolean isError() {
        return this.h;
    }

    public boolean isOutOfMemoryError() {
        return this.i;
    }

    public void setResized(boolean bl) {
        this.m = bl;
    }

    public boolean isResized() {
        return this.m;
    }
}

