/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.util.DiagramElements;
import net.astah.golf.draw.GNode;
import net.astah.golf.emf.EMFGraphics2D;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.widget.swing.SwingCanvas;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.UsagePresentation;
import net.astah.jomt.jcontrol.JudeToImageCommand;
import net.astah.jomt.jcontrol.ToImageUtil;
import net.astah.jomt.jutil.JomtFileFilter;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.Editor;
import net.astah.jomt.jview.JomtCanvas;
import net.astah.jomt.jviewElement.CJomtTextNode;
import net.astah.notation.mindmap.MMDiagramElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JudeToEmfCommand
extends JudeToImageCommand {
    private Dimension b;
    boolean a = false;
    private List<GNode> c = null;
    private List<GNode> d = null;
    private static final Logger e = LoggerFactory.getLogger(JudeToEmfCommand.class);

    @Override
    protected String getFormatName() {
        return "emf";
    }

    @Override
    protected String addExtention(String string) {
        if (!string.endsWith(".emf") && !string.endsWith(".EMF")) {
            string = string + ".emf";
        }
        return string;
    }

    protected String[] getFileFilterFirstName() {
        return new String[]{"emf"};
    }

    protected String getFileFilterSecondName() {
        return "EMF image file";
    }

    @Override
    protected JomtFileFilter getFileFilter() {
        JomtFileFilter jomtFileFilter = new JomtFileFilter(new String[]{"emf"}, "EMF image file");
        return jomtFileFilter;
    }

    @Override
    protected void outputImageFile(Editor editor, String string) {
        this.a = true;
        super.outputImageFile(editor, string);
    }

    @Override
    protected void outputImageFile(DiagramEditor diagramEditor, String string) {
        this.a = false;
        JomtCanvas jomtCanvas = (JomtCanvas)((SwingCanvas)diagramEditor.getCanvas()).getComponent();
        this.c = jomtCanvas.getSelectedNodes();
        this.d = diagramEditor.getEditingNodes();
        super.outputImageFile(diagramEditor, string);
    }

    @Override
    protected Graphics2D getGraphics(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, BufferedImage bufferedImage, OutputStream outputStream) {
        int n2;
        int n3;
        double d2;
        double d3;
        if (this.a) {
            d3 = 0.0;
            d2 = 0.0;
            n3 = this.b.width;
            n2 = this.b.height;
        } else {
            d3 = ToImageUtil.getImageX(rectangle2D2);
            d2 = ToImageUtil.getImageY(rectangle2D2);
            n3 = ToImageUtil.getImageWidth(rectangle2D2);
            n2 = ToImageUtil.getImageHeight(rectangle2D2);
        }
        String string = RuntimeGlobal.sysProp.getStringWithDefault("emf.font.sequence");
        EMFGraphics2D eMFGraphics2D = new EMFGraphics2D(new Rectangle((int)Math.round(d3), (int)Math.round(d2), (int)Math.round((double)n3), (int)Math.round((double)n2)), string);
        return eMFGraphics2D;
    }

    @Override
    protected DiagramElement[] getPresentations(@NonNull DiagramEditor diagramEditor, @NonNull JomtCanvas jomtCanvas) {
        if (diagramEditor == null) {
            throw new NullPointerException("de");
        }
        if (jomtCanvas == null) {
            throw new NullPointerException("canvas");
        }
        if (GraphicsEnvironment.isHeadless()) {
            return super.getPresentations(diagramEditor, jomtCanvas);
        }
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        for (DiagramElement diagramElement : Lists.newArrayList(DiagramElements.getAllContents(diagramEditor.getDiagram()))) {
            if (diagramElement instanceof ClassifierPresentation) {
                if (!((ClassifierPresentation)diagramElement).isVisibility()) continue;
                diagramEditor.select(diagramElement);
                arrayList.add(diagramElement);
                continue;
            }
            if (diagramElement instanceof UsagePresentation) {
                if (!((UsagePresentation)diagramElement).isVisibility()) continue;
                diagramEditor.select(diagramElement);
                arrayList.add(diagramElement);
                continue;
            }
            diagramEditor.select(diagramElement);
            arrayList.add(diagramElement);
        }
        return arrayList.toArray(new DiagramElement[0]);
    }

    @Override
    protected MMDiagramElement[] getMMDiagramElements(@NonNull DiagramEditor diagramEditor, @NonNull JomtCanvas jomtCanvas) {
        if (diagramEditor == null) {
            throw new NullPointerException("de");
        }
        if (jomtCanvas == null) {
            throw new NullPointerException("canvas");
        }
        MMDiagramElement[] mMDiagramElementArray = super.getMMDiagramElements(diagramEditor, jomtCanvas);
        if (GraphicsEnvironment.isHeadless()) {
            return mMDiagramElementArray;
        }
        for (MMDiagramElement mMDiagramElement : mMDiagramElementArray) {
            diagramEditor.select(mMDiagramElement);
        }
        return mMDiagramElementArray;
    }

    @Override
    protected boolean isSupportFormat() {
        return true;
    }

    @Override
    protected void encode(BufferedImage bufferedImage, Graphics graphics, FileOutputStream fileOutputStream) throws IOException {
        byte[] byArray = ((EMFGraphics2D)graphics).getEMFOutputStream().toByteArray();
        try {
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            e.error("error has occurred.", fileNotFoundException);
        }
        catch (IOException iOException) {
            e.error("error has occurred.", iOException);
        }
    }

    @Override
    protected BufferedImage getImage(int n2, int n3, double d2) {
        if (this.a) {
            this.b = new Dimension(n2, n3);
        }
        return null;
    }

    @Override
    protected int getImageType() {
        return -1;
    }

    @Override
    protected boolean withBackground() {
        return true;
    }

    @Override
    protected void unselect(JomtCanvas jomtCanvas) {
        if (!GraphicsEnvironment.isHeadless()) {
            jomtCanvas.unselect();
            jomtCanvas.select(this.c);
            for (GNode gNode : this.d) {
                ((CJomtTextNode)gNode).setComponentFocus(true);
            }
            this.c = null;
            this.d = null;
            jomtCanvas.draw();
        }
    }
}

