/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.control.Command;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.CFileChooser;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.importer.asta.AstaImporterJob;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.CreateViewSeqCommand;
import net.astah.jomt.jcontrol.z;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.ProjectTreeModel;
import net.astah.uml2.uml.ui.control.CreateNewUMLPrjSeqCommand;
import org.eclipse.core.runtime.IStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportProPrjCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(ImportProPrjCommand.class);
    private File b;
    private static final String c = ".asta";

    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        CreateNewUMLPrjSeqCommand createNewUMLPrjSeqCommand = new CreateNewUMLPrjSeqCommand();
        this.callCommand(createNewUMLPrjSeqCommand);
        Project project2 = ModelGlobal.prjManager.getCurrentProject();
        if (project2 == null || project2 == project) {
            return;
        }
        URL uRL = this.getProjectURL();
        if (uRL == null) {
            return;
        }
        Project project3 = ModelGlobal.prjManager.getCurrentProject();
        AstaImporterJob astaImporterJob = new AstaImporterJob((IEntityStore)project3.doc, uRL);
        astaImporterJob.addJobChangeListener(Jobs.done(iJobChangeEvent -> {
            IStatus iStatus2 = iJobChangeEvent.getResult();
            if (!iStatus2.isOK() && iStatus2.getSeverity() < 8) {
                MessageManager.displayStatusMessageDialog("app", "tell_asta_import_result_differences.message", iStatus2);
                Jobs.visit(iStatus2, iStatus -> {
                    switch (iStatus.getSeverity()) {
                        case 1: {
                            a.info(iStatus.getMessage(), iStatus.getException());
                            break;
                        }
                        case 2: {
                            a.warn(iStatus.getMessage(), iStatus.getException());
                            break;
                        }
                        case 4: {
                            a.error(iStatus.getMessage(), iStatus.getException());
                        }
                    }
                });
            }
            if (iStatus2.getSeverity() < 4) {
                this.a(project3);
            }
        }, true));
        astaImporterJob.schedule();
    }

    private void a(Project project) {
        if (!GraphicsEnvironment.isHeadless() && !JomtGlobal.isNoGUI()) {
            CreateViewSeqCommand createViewSeqCommand = new CreateViewSeqCommand();
            createViewSeqCommand.setProject(project);
            createViewSeqCommand.setUseBaseSplitPaneLocation(false);
            this.callCommand(createViewSeqCommand);
        } else {
            ProjectTreeModel.updateProjectName(project.doc.getName());
        }
    }

    protected URL getProjectURL() {
        if (this.b == null) {
            this.b = this.a();
        }
        if (this.b == null) {
            return null;
        }
        JomtGlobal.setFileDir(this.b.getParent());
        if (!this.a(this.b)) {
            this.b = new File(this.b.getAbsolutePath() + c);
        }
        try {
            if (this.b.canRead()) {
                return this.b.toURI().toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {
            a.warn("Cannot convert file to URL", malformedURLException);
        }
        MessageManager.displayErrorMessage("app", "tell_open_fail.message");
        return null;
    }

    private File a() {
        File file = null;
        if (PropertyManager.isMacOS()) {
            Frame frame = (Frame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
            FileDialog fileDialog = new FileDialog(frame);
            fileDialog.setMode(0);
            fileDialog.setFilenameFilter(new z(this));
            fileDialog.setDirectory(JomtGlobal.getFileDir());
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                file = new File(GolfUtilities.normalizeToNFC(fileDialog.getDirectory() + fileDialog.getFile()));
            }
        } else {
            String string = JomtGlobal.getFileDir();
            CFileChooser cFileChooser = JomtWidgetFactory.instance().createFileChooser(string, "Open Dialog");
            cFileChooser.setFileFilter("asta", "Project Files");
            if (cFileChooser.isApproveOpenDialog()) {
                file = cFileChooser.getSelectedFile();
            }
        }
        return file;
    }

    private boolean a(File file) {
        return file.getName().toLowerCase().endsWith(c);
    }

    static /* synthetic */ boolean a(ImportProPrjCommand importProPrjCommand, File file) {
        return importProPrjCommand.a(file);
    }
}

