/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.edit.provider.Geometries;
import net.astah.dd.di.edit.provider.LayoutCalculator;
import net.astah.golf.control.Command;
import net.astah.golf.geom2D.Vec2d;
import net.astah.golf.widget.CCanvas;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.edit.layout.DiagramElementOperations;

public class FitWindowCommand
extends Command {
    public static final String WIDTH_FIT_WINDOW = "width";
    public static final String HEIGHT_FIT_WINDOW = "height";
    public static final String BOTH_FIT_WINDOW = "both";
    protected String arg;
    private boolean a = true;

    @Override
    public void execute() {
        try {
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (diagramEditor == null) {
                return;
            }
            CCanvas cCanvas = diagramEditor.getCanvas();
            Rectangle rectangle = cCanvas.getVisibleRect();
            double d2 = rectangle.getWidth() * 0.98;
            double d3 = rectangle.getHeight() * 0.98;
            Rectangle2D rectangle2D = this.a(diagramEditor.getDiagram());
            if (rectangle2D != null && !rectangle2D.isEmpty()) {
                double d4 = d2 / rectangle2D.getWidth();
                double d5 = d3 / rectangle2D.getHeight();
                double d6 = this.a(d4, d5);
                diagramEditor.zoom(d6 * (this.a ? 1.0 : DiagramEditor.ZOOM_SCALE_DEFAULT), true);
                Vec2d vec2d = this.a(diagramEditor, rectangle2D);
                diagramEditor.pan(vec2d);
                diagramEditor.repaintCanvas();
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    public void setFromMenu(boolean bl) {
        this.a = bl;
    }

    private Rectangle2D a(Diagram diagram) {
        if (diagram instanceof UMLDiagram) {
            return DiagramElementOperations.getBoundsRect(diagram.getOwnedElements(), true);
        }
        return Geometries.toRectangle2d(new LayoutCalculator().getTotalBounds((Iterable<?>)diagram.getOwnedElements(), true));
    }

    @Override
    public void setArgumentString(String string) {
        this.arg = string;
    }

    private double a(double d2, double d3) {
        double d4 = DiagramEditor.ZOOM_SCALE_DEFAULT;
        if (BOTH_FIT_WINDOW.equals(this.arg)) {
            if (d2 <= DiagramEditor.ZOOM_SCALE_DEFAULT || d3 <= DiagramEditor.ZOOM_SCALE_DEFAULT) {
                d4 = Math.min(d2, d3);
            }
        } else if (WIDTH_FIT_WINDOW.equals(this.arg)) {
            if (d2 <= DiagramEditor.ZOOM_SCALE_DEFAULT) {
                d4 = d2;
            }
        } else if (HEIGHT_FIT_WINDOW.equals(this.arg) && d3 <= DiagramEditor.ZOOM_SCALE_DEFAULT) {
            d4 = d3;
        }
        return d4;
    }

    private Vec2d a(DiagramEditor diagramEditor, Rectangle2D rectangle2D) {
        CCanvas cCanvas = diagramEditor.getCanvas();
        Rectangle rectangle = cCanvas.getVisibleRect();
        double d2 = diagramEditor.getCamera().getPositionX();
        double d3 = diagramEditor.getCamera().getPositionY();
        double d4 = diagramEditor.getCamera().getScale();
        double d5 = rectangle.getWidth() / d4 - rectangle2D.getWidth();
        double d6 = rectangle.getHeight() / d4 - rectangle2D.getHeight();
        double d7 = rectangle2D.getX();
        double d8 = rectangle2D.getY();
        if (BOTH_FIT_WINDOW.equals(this.arg)) {
            d7 = d7 - d2 - d5 / 2.0;
            d8 = d8 - d3 - d6 / 2.0;
        } else if (WIDTH_FIT_WINDOW.equals(this.arg)) {
            d7 = d7 - d2 - d5 / 2.0;
            d8 = 0.0;
        } else if (HEIGHT_FIT_WINDOW.equals(this.arg)) {
            d7 = 0.0;
            d8 = d8 - d3 - d6 / 2.0;
        }
        Vec2d vec2d = new Vec2d(d7, d8);
        return vec2d;
    }
}

