/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import net.astah.emf.edit.job.Jobs;
import net.astah.emf.edit.job.TransactionalJob;
import net.astah.golf.control.Command;
import net.astah.golf.model.EMFEntityStore;
import net.astah.golf.model.IEntityStore;
import net.astah.golf.widget.CFileChooser;
import net.astah.jmodel.EntityAccessor;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.y;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.PathUtil;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml2.export.UMLExporter;
import net.astah.uml2.uml.resource.impl.ExtensionUMLResourceFactoryImpl;
import net.astah.uml2.uml.resource.impl.ExtensionXMI2UMLResourceFactoryImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportXMICommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(ExportXMICommand.class);
    private File b;

    @Override
    public void execute() {
        Object object;
        Object object2;
        int n2;
        Project project = ModelGlobal.prjManager.getCurrentProject();
        if (project == null || !(project.doc instanceof EMFEntityStore)) {
            return;
        }
        if (this.b == null) {
            try {
                this.b = SwingInvoker.runInEDTAndWaitResult(new y(this));
            }
            catch (InvocationTargetException invocationTargetException) {
                a.error("error has occurred.", invocationTargetException);
                return;
            }
            catch (InterruptedException interruptedException) {
                a.error("error has occurred.", interruptedException);
                return;
            }
            if (this.b == null) {
                return;
            }
        }
        if (!PathUtil.isLegalFileName(this.b.getName())) {
            MessageManager.displayAlertMessageDialog("app", "tell_save_fail_illegal_file_name.message");
            return;
        }
        String string = this.b.getAbsolutePath();
        JomtGlobal.setFileDir(this.b.getParent());
        if (!string.endsWith(".xmi") && !string.endsWith(".uml")) {
            string = string + ".xmi";
        }
        a.info("file: {}", (Object)string);
        File file = new File(string);
        if (file.exists() && (n2 = MessageManager.displayMessageYesNoDialog("app", "ask_overwrite_file.message")) != 0 && n2 != -1) {
            if (n2 == 1) {
                this.b = null;
                this.execute();
            }
            return;
        }
        File file2 = new File(file.getAbsolutePath());
        if (file2.exists()) {
            if (!file2.canWrite()) {
                MessageManager.displayAlertMessageDialog("app", "read_only.message");
                return;
            }
            object2 = file2 + ".bak";
            object = new File((String)object2);
            if (((File)object).exists()) {
                ((File)object).delete();
            }
            file2.renameTo((File)object);
        }
        object2 = project.doc;
        object = (TransactionalEditingDomain)object2.getDomain();
        Set<EObject> set = Collections.singleton(EntityAccessor.getProjectModel((IEntityStore)object2));
        URI uRI = URI.createFileURI(file2.getAbsolutePath());
        ExportXMIJob exportXMIJob = new ExportXMIJob((TransactionalEditingDomain)object, set, uRI);
        Jobs.toCompletableFuture(exportXMIJob, true).exceptionally(throwable -> {
            if (throwable.getCause() instanceof IOException) {
                MessageManager.displayErrorMessage("app", "tell_save_fail.message");
            } else {
                MessageManager.requireBugReport(throwable);
            }
            return null;
        });
        exportXMIJob.schedule();
    }

    protected CFileChooser getFileChooser() {
        Serializable serializable;
        String string = JomtGlobal.getFileDir();
        CFileChooser cFileChooser = JomtWidgetFactory.instance().createFileChooser(string, "Save Dialog");
        cFileChooser.setFileFilter("xmi", "XMI Files");
        cFileChooser.addChoosableFileFilter("uml", "UML2 XMI Files");
        Model model = (Model)EntityAccessor.getProjectModel();
        String string2 = model.getName();
        if ("no_title".equals(string2) && (serializable = EntityAccessor.getDiagram(model)) != null) {
            string2 = serializable.getName();
        }
        if (string2 != "") {
            string2 = PathUtil.getLegalFileName(string2);
            serializable = new File(JomtGlobal.getFileDir(), string2);
            cFileChooser.setSelectedFile((File)serializable);
        }
        return cFileChooser;
    }

    public void setFile(File file) {
        this.b = file;
    }

    public static class ExportXMIJob
    extends TransactionalJob {
        protected final Iterable<EObject> selection;
        protected final URI targetURI;

        public ExportXMIJob(TransactionalEditingDomain transactionalEditingDomain, Iterable<EObject> iterable, URI uRI) {
            super(transactionalEditingDomain, "Export XMI");
            this.selection = iterable;
            this.targetURI = uRI;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected IStatus run(IProgressMonitor iProgressMonitor) {
            UMLExporter uMLExporter = new UMLExporter();
            try {
                this.runExclusive(() -> {
                    this.doExport(uMLExporter, iProgressMonitor);
                    return null;
                });
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (InterruptedException | CancellationException exception) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            catch (ExecutionException executionException) {
                Status status = new Status(4, "<N/A>", "Failed to export XMI", executionException.getCause());
                return status;
            }
            finally {
                uMLExporter.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doExport(UMLExporter uMLExporter, IProgressMonitor iProgressMonitor) throws Exception {
            SubMonitor subMonitor = SubMonitor.convert(iProgressMonitor, "Exporting XMI", 100);
            try {
                ResourceSet resourceSet = uMLExporter.getResourceSet();
                UMLUtil.init(resourceSet);
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("uml", new ExtensionUMLResourceFactoryImpl());
                resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("xmi", new ExtensionXMI2UMLResourceFactoryImpl());
                subMonitor.worked(1);
                uMLExporter.export(this.selection, this.targetURI, subMonitor.newChild(79));
                uMLExporter.save(null, subMonitor.newChild(20));
            }
            finally {
                subMonitor.done();
            }
        }
    }
}

