/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.astah.emf.compare.ui.provider.DiffOperations;
import net.astah.golf.widget.CFileChooser;
import net.astah.jomt.jcontrol.ExportProjectDifferenceCommand;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.ecore.EObject;

public class ExportProjectDifferenceToCSVCommand
extends ExportProjectDifferenceCommand {
    private static final Object[] a = new Object[]{"Diff ID", "Kind", "Type", "Left", "Right", "Value"};

    public ExportProjectDifferenceToCSVCommand(List<Diff> list) {
        super(list);
    }

    @Override
    protected String getFileExtension() {
        return ".csv";
    }

    @Override
    protected void setFileFilter(CFileChooser cFileChooser) {
        cFileChooser.setFileFilter("csv", "CSV Files");
    }

    @Override
    protected void exportDifferences() throws IOException {
        this.differences = ((Diff)this.differences.get(0)).getMatch().getComparison().getDifferences();
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);){
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
            ((Writer)outputStreamWriter).write(65279);
            try (CSVPrinter cSVPrinter = new CSVPrinter(outputStreamWriter, CSVFormat.EXCEL);){
                cSVPrinter.printRecord(a);
                for (int i2 = 0; i2 < this.differences.size(); ++i2) {
                    Diff diff = (Diff)this.differences.get(i2);
                    cSVPrinter.printRecord(this.b(diff, i2 + 1));
                    for (Iterable<?> iterable : this.a(diff, i2 + 1)) {
                        cSVPrinter.printRecord(iterable);
                    }
                }
            }
        }
    }

    private Iterable<Iterable<?>> a(Diff diff, int n2) {
        ArrayList arrayList = new ArrayList();
        this.a(diff.getRefinedBy(), "RefinedBy", n2, arrayList);
        this.a(diff.getRefines(), "Refines", n2, arrayList);
        this.a(diff.getRequiredBy(), "RequiredBy", n2, arrayList);
        this.a(diff.getRequires(), "Requires", n2, arrayList);
        return arrayList;
    }

    private void a(List<Diff> list, String string, int n2, List<Iterable<?>> list2) {
        for (Diff diff : list) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            arrayList.add(string);
            arrayList.add(String.valueOf(this.differences.indexOf(diff) + 1));
            arrayList.add(DiffOperations.getLabel((Object)this.a(diff)));
            list2.add(arrayList);
        }
    }

    private EObject a(Diff diff) {
        DifferenceKind differenceKind;
        DifferenceKind differenceKind2 = differenceKind = diff.getSource() == DifferenceSource.LEFT ? DifferenceKind.DELETE : DifferenceKind.ADD;
        if (diff.getKind() == differenceKind) {
            return diff.getMatch().getRight();
        }
        return diff.getMatch().getLeft();
    }

    private Iterable<?> b(Diff diff, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.valueOf(n2));
        arrayList.add(diff.getKind().getLiteral());
        arrayList.add(diff.eClass().getName());
        Match match = diff.getMatch();
        if (match != null) {
            arrayList.add(DiffOperations.getLabel((Object)match.getLeft()));
            arrayList.add(DiffOperations.getLabel((Object)match.getRight()));
            arrayList.add(DiffOperations.getValueLabel((Diff)diff));
        }
        return arrayList;
    }
}

