/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.List;
import net.astah.golf.control.Command;
import net.astah.golf.util.GolfUtilities;
import net.astah.golf.widget.CFileChooser;
import net.astah.golf.widget.swing.SwingComponent;
import net.astah.jomt.jcontrol.x;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.DocumentUtil;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jview.MessageManager;
import org.eclipse.emf.compare.Diff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExportProjectDifferenceCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(ExportProjectDifferenceCommand.class);
    protected File file;
    protected List<Diff> differences;

    public ExportProjectDifferenceCommand(List<Diff> list) {
        this.differences = list;
    }

    @Override
    public void execute() {
        if (this.differences == null || this.differences.isEmpty()) {
            return;
        }
        if (this.file == null) {
            this.file = this.a();
        }
        if (this.file == null) {
            return;
        }
        if (!this.file.getName().endsWith(this.getFileExtension())) {
            this.file = new File(this.file.getAbsolutePath() + this.getFileExtension());
        }
        a.info("file: {}", (Object)this.file.getAbsolutePath());
        if (this.file.getParentFile() != null && !this.file.getParentFile().exists()) {
            this.file.getParentFile().mkdirs();
        }
        try {
            this.exportDifferences();
            this.a(this.file);
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected abstract void exportDifferences() throws IOException;

    private File a() {
        File file = null;
        if (PropertyManager.isMacOS()) {
            Frame frame = (Frame)((SwingComponent)JomtGlobal.viewManager.getManagementView().getComponent()).getComponent();
            FileDialog fileDialog = new FileDialog(frame);
            fileDialog.setMode(1);
            fileDialog.setFilenameFilter(new x(this));
            fileDialog.setDirectory(JomtGlobal.getFileDir());
            fileDialog.setVisible(true);
            if (fileDialog.getFile() != null) {
                file = new File(GolfUtilities.normalizeToNFC(fileDialog.getDirectory() + fileDialog.getFile()));
            }
        } else {
            String string = JomtGlobal.getFileDir();
            CFileChooser cFileChooser = JomtWidgetFactory.instance().createFileChooser(string, "Save Dialog");
            this.setFileFilter(cFileChooser);
            if (cFileChooser.isApproveOpenDialog()) {
                file = cFileChooser.getSelectedFile();
            }
        }
        return file;
    }

    protected abstract void setFileFilter(CFileChooser var1);

    protected abstract String getFileExtension();

    private void a(File file) {
        int n2 = MessageManager.displayYesNoDialog("app", "confirm_open_exported_file.message");
        if (n2 == 0) {
            try {
                DocumentUtil.openDocument(file.toURI().toURL());
            }
            catch (Exception exception) {
                MessageManager.displayAlertMessageDialog("app", "tell_open_fail.message");
            }
        }
    }

    public void setFile(File file) {
        this.file = file;
    }
}

