/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Component;
import java.util.Iterator;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.TemplateParameterHolder;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.TemplateParameter;
import org.eclipse.uml2.uml.TemplateableElement;

public abstract class EditTemplateParameterFromPropViewCommand
extends Command {
    protected TemplateParameterHolder templateParameterHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            TemplateParameter templateParameter = this.getSeletedTemplateParameter();
            if (templateParameter == null) {
                return;
            }
            try {
                TemplateableElement templateableElement;
                iJomtEntityStore.beginTransaction();
                if (templateParameter.getSignature() != null && (templateableElement = templateParameter.getSignature().getTemplate()) instanceof Classifier) {
                    this.changeOrder(templateParameter, (Classifier)templateableElement);
                }
                iJomtEntityStore.commitTransaction();
                this.selectParameter(templateParameter);
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected abstract void changeOrder(TemplateParameter var1, Classifier var2);

    protected TemplateParameter getSeletedTemplateParameter() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
        Component component = modelTabGroup.getSelectedComponent();
        if (component instanceof TemplateParameterHolder) {
            this.templateParameterHolder = (TemplateParameterHolder)((Object)component);
            Iterator<TemplateParameter> iterator = this.templateParameterHolder.getSelectedParameters();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
        return null;
    }

    protected void selectParameter(TemplateParameter templateParameter) {
        if (this.templateParameterHolder != null) {
            this.templateParameterHolder.selectParameter(templateParameter);
        }
    }
}

