/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import net.astah.dd.dc.DCFactory;
import net.astah.dd.dc.Point;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.emf.common.resource.ResourceStorage;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.util.RuntimeGlobal;
import net.astah.golf.view.swing.SwingResourceStorages;
import net.astah.golf.widget.CFileChooser;
import net.astah.golf.widget.CImageIcon;
import net.astah.golf.widget.swing.SwingImageIcon;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtWidgetFactory;
import net.astah.jomt.jutil.PathUtil;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.edit.command.Notations;
import net.astah.notation.mindmap.MMImage;
import net.astah.notation.mindmap.MMNotationFactory;
import net.astah.notation.mindmap.MMTopicShape;
import org.eclipse.emf.common.util.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditMMImageCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(EditMMImageCommand.class);
    public static final String ICON_REFIX = "diagramview.popupmenu.edit_mm_image.group.";
    private static final double b = 100.0;
    private static final double c = 100.0;
    private CImageIcon d = null;
    private File e = null;
    private Diagram f;
    private boolean g = false;
    private DiagramElement[] h;
    private boolean i = true;
    private URI j;

    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            if (diagramEditor == null) {
                return;
            }
            this.f = diagramEditor.getDiagram();
            if (this.f == null) {
                return;
            }
            if (this.h == null || this.h.length == 0) {
                this.h = diagramEditor.getSelectedPresentations();
            }
            if (this.h == null || this.h.length == 0) {
                return;
            }
            try {
                if (this.i) {
                    iJomtEntityStore.beginTransaction();
                }
                for (int i2 = 0; i2 < this.h.length; ++i2) {
                    DiagramElement diagramElement = this.h[i2];
                    if (!(diagramElement instanceof MMTopicShape)) continue;
                    MMTopicShape mMTopicShape = (MMTopicShape)diagramElement;
                    if (this.d == null) {
                        if (this.e == null) {
                            CFileChooser cFileChooser = this.createImageFileChooser();
                            if (!cFileChooser.isApproveOpenDialog()) {
                                if (this.i) {
                                    iJomtEntityStore.abortTransaction();
                                }
                                return;
                            }
                            this.e = cFileChooser.getSelectedFile();
                            JomtGlobal.setFileDir(this.e.getParent());
                        }
                        if (!this.e.canRead()) {
                            MessageManager.displayErrorMessage("app", "tell_open_fail.message");
                            if (this.i) {
                                iJomtEntityStore.abortTransaction();
                            }
                            return;
                        }
                        try {
                            this.d = this.getImageIcon(this.e);
                        }
                        catch (IOException iOException) {
                            a.warn("Failed to load image: {}", (Object)iOException.getMessage());
                            MessageManager.displayErrorMessage("app", "tell_open_fail.message");
                            if (this.i) {
                                iJomtEntityStore.abortTransaction();
                            }
                            return;
                        }
                    }
                    if (this.d == null) {
                        MessageManager.displayErrorMessage("app", "tell_open_fail.message");
                        if (this.i) {
                            iJomtEntityStore.abortTransaction();
                        }
                        return;
                    }
                    this.setImageIconToTopic(mMTopicShape, this.d);
                    JomtGlobal.modeManager.changeButtonsState(this.g);
                }
                if (this.i) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.i) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.i) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    public void setImageIconToTopic(MMTopicShape mMTopicShape, CImageIcon cImageIcon) {
        MMImage mMImage = MMNotationFactory.eINSTANCE.createMMImage();
        mMTopicShape.setImage(mMImage);
        double d2 = cImageIcon.getWidth(null);
        double d3 = cImageIcon.getHeight(null);
        Point point = mMTopicShape.getLocation_();
        mMImage.setSource(this.j.toString());
        this.a(mMImage, point.getX(), point.getY(), d2, d3);
    }

    private void a(MMImage mMImage, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        boolean bl = RuntimeGlobal.sysProp.getBooleanWithDefault("default_size.max_image.default_use");
        if (bl) {
            d7 = this.a(d4, "default_size.max_image.default_width", 100.0);
            d6 = this.a(d5, "default_size.max_image.default_height", 100.0);
        } else {
            d7 = 1.0;
            d6 = 1.0;
        }
        double d8 = this.a(d4, d7, d6);
        double d9 = this.a(d5, d7, d6);
        Notations.setSize(mMImage, d8, d9);
        mMImage.setBounds(DCFactory.eINSTANCE.createBounds(d2, d3, d8, d9));
    }

    private double a(double d2, String string, double d3) {
        double d4 = RuntimeGlobal.sysProp.getIntWithDefault(string);
        if (d4 == -1.0) {
            d4 = d3;
        }
        return d4 / d2;
    }

    private double a(double d2, double d3, double d4) {
        if (d3 >= 1.0 && d4 >= 1.0) {
            return d2;
        }
        return d2 * Math.min(d3, d4);
    }

    protected CImageIcon getImageIcon(File file) throws IOException {
        String string = file.getName().toLowerCase();
        if (string.endsWith(".jpg") || string.endsWith(".jpeg") || string.endsWith(".gif") || string.endsWith(".png")) {
            ResourceStorage resourceStorage = ResourceStorage.getResourceStorage(this.f);
            this.j = resourceStorage.store(file);
            return SwingResourceStorages.getImage(resourceStorage, this.j);
        }
        return null;
    }

    protected CFileChooser createImageFileChooser() {
        String string = JomtGlobal.getFileDir();
        CFileChooser cFileChooser = JomtWidgetFactory.instance().createFileChooser(string, "Open Dialog");
        cFileChooser.addChoosableFileFilter(new String[]{"jpg", "jpeg"}, "JPEG Compressed Image Files");
        cFileChooser.addChoosableFileFilter("gif", "GIF Image Files");
        cFileChooser.addChoosableFileFilter("png", "PNG Image Files");
        cFileChooser.setFileFilter(new String[]{"jpg", "jpeg", "gif", "png"}, "Supported Image Files");
        return cFileChooser;
    }

    @Override
    public void setArgumentString(String string) {
        if (string != null) {
            ImageIcon imageIcon = PathUtil.getIcon(PropertyManager.getDiagramEditorResourceBundle().getString(ICON_REFIX + string + ".image"));
            this.d = new SwingImageIcon(imageIcon);
        }
    }

    public void setDiagram(Diagram diagram) {
        this.f = diagram;
    }

    public void setShiftPressedState(boolean bl) {
        this.g = bl;
    }

    public void setFile(File file) {
        this.e = file;
    }

    public void setSelectedPresentations(DiagramElement[] diagramElementArray) {
        this.h = diagramElementArray;
    }

    public void setDoTransaction(boolean bl) {
        this.i = bl;
    }

    public void setImageIcon(CImageIcon cImageIcon) {
        this.d = cImageIcon;
    }
}

