/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Component;
import java.util.Iterator;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.EnumerationLiteralTab;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Namespace;

public abstract class EditEnumerationLiteralFromPropViewCommand
extends Command {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
            ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
            Component component = modelTabGroup.getSelectedComponent();
            Iterator<EnumerationLiteral> iterator = null;
            EnumerationLiteralTab enumerationLiteralTab = null;
            if (component instanceof EnumerationLiteralTab) {
                enumerationLiteralTab = (EnumerationLiteralTab)component;
                iterator = enumerationLiteralTab.getSelectedEnumerationLiterals();
            }
            EnumerationLiteral enumerationLiteral = null;
            if (!iterator.hasNext()) {
                return;
            }
            enumerationLiteral = iterator.next();
            try {
                iJomtEntityStore.beginTransaction();
                Namespace namespace = enumerationLiteral.getNamespace();
                Enumeration enumeration = (Enumeration)namespace;
                this.changeOrder(enumerationLiteral, enumeration);
                iJomtEntityStore.commitTransaction();
                if (enumerationLiteralTab != null) {
                    enumerationLiteralTab.selectEnumerationLiteral(enumerationLiteral);
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected abstract void changeOrder(EnumerationLiteral var1, Enumeration var2);
}

