/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Component;
import java.util.Iterator;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.AttributeHolder;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import net.astah.uml2.uml.Properties;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;

public abstract class EditAttributeFromPropViewCommand
extends Command {
    protected AttributeHolder attributeHolder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            Property property = this.getSeletedAttribute();
            if (property == null) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                Namespace namespace = property.getNamespace();
                if (namespace != null) {
                    AttributeOwner attributeOwner = (AttributeOwner)((Object)namespace);
                    this.changeOrder(property, attributeOwner);
                } else if (Properties.isQualifier(property)) {
                    this.changeOrder(property, (Property)property.eContainer());
                }
                iJomtEntityStore.commitTransaction();
                this.selectAttribute(property);
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected abstract void changeOrder(Property var1, AttributeOwner var2);

    protected abstract void changeOrder(Property var1, Property var2);

    protected Property getSeletedAttribute() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
        Component component = modelTabGroup.getSelectedComponent();
        if (component instanceof AttributeHolder) {
            this.attributeHolder = (AttributeHolder)((Object)component);
            Iterator<Property> iterator = this.attributeHolder.getSelectedAttributes();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
        return null;
    }

    protected void selectAttribute(Property property) {
        if (this.attributeHolder != null) {
            this.attributeHolder.selectAttribute(property);
        }
    }
}

