/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.edit.layout.DiagramElementOperations;
import net.astah.uml2.uml.AttributeOwners;
import net.astah.uml2.uml.Enumerations;
import net.astah.uml2.uml.OperationOwners;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.AttributeOwner;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OperationOwner;
import org.eclipse.uml2.uml.Property;

public class DgmEditorMoveDownCommand
extends Command {
    @Override
    public void execute() {
        DiagramEditor diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            Object[] objectArray = diagramEditor.getSelectedModels();
            Element element = this.getFeatureModel(objectArray);
            if (!(element instanceof Feature) && !(element instanceof EnumerationLiteral)) {
                return;
            }
            iJomtEntityStore.beginTransaction();
            if (element instanceof Property) {
                Property property = (Property)element;
                if (property.getNamespace() != null) {
                    AttributeOwner attributeOwner = (AttributeOwner)((Object)property.getNamespace());
                    AttributeOwners.down(attributeOwner, property);
                }
            } else if (element instanceof Operation) {
                Operation operation = (Operation)element;
                OperationOwner operationOwner = (OperationOwner)((Object)operation.getNamespace());
                OperationOwners.down(operationOwner, operation);
            } else if (element instanceof EnumerationLiteral) {
                Enumeration enumeration = (Enumeration)element.getOwner();
                Enumerations.down(enumeration, (EnumerationLiteral)element);
            }
            iJomtEntityStore.commitTransaction();
        }
        catch (BadTransactionException badTransactionException) {
            MessageManager.requireBugReport(badTransactionException);
            iJomtEntityStore.abortTransaction();
        }
        catch (Exception exception) {
            iJomtEntityStore.abortTransaction();
            MessageManager.requireBugReport(exception);
        }
    }

    protected Element getFeatureModel(Object[] objectArray) {
        EObject eObject;
        if (objectArray.length == 1 && (eObject = DiagramElementOperations.getModel(objectArray[0])) instanceof Element) {
            return (Element)eObject;
        }
        return null;
    }
}

