/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.TemplateParameterHolder;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.uml.TemplateParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTemplateParameterFromPropViewCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(DeleteTemplateParameterFromPropViewCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            Set<EObject> set = this.getSeletedItems();
            if (set.isEmpty()) {
                return;
            }
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            try {
                iJomtEntityStore.beginTransaction();
                EditingDomain editingDomain = iJomtEntityStore.getDomain();
                CommandUtils.execute(editingDomain, DestroyCommand.create(editingDomain, set));
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException | RollbackException exception) {
                a.error("error has occurred.", exception);
                MessageManager.requireBugReport(exception);
                iJomtEntityStore.abortTransaction();
            }
        }
        catch (Exception exception) {
            a.error("error has occurred.", exception);
            MessageManager.requireBugReport(exception);
        }
    }

    protected Set<EObject> getSeletedItems() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
        Component component = modelTabGroup.getSelectedComponent();
        HashSet<EObject> hashSet = new HashSet<EObject>();
        if (component instanceof TemplateParameterHolder) {
            TemplateParameterHolder templateParameterHolder = (TemplateParameterHolder)((Object)component);
            Iterator<TemplateParameter> iterator = templateParameterHolder.getSelectedParameters();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
        }
        return hashSet;
    }
}

