/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.StereotypeUtil;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import net.astah.jomt.jview.proptab.RequiredInterfaceTab;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Usage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteRequiredInterfaceFromPropViewCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(DeleteRequiredInterfaceFromPropViewCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            Port port = this.getPort();
            if (port == null) {
                return;
            }
            if (port.getType() == null) {
                return;
            }
            List<Interface> list = this.getSeletedInterfaces();
            if (list == null || list.isEmpty()) {
                return;
            }
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            try {
                iJomtEntityStore.beginTransaction();
                this.a(port, list);
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    private void a(Port port, List<Interface> list) {
        ArrayList<Dependency> arrayList = new ArrayList<Dependency>();
        Type type = port.getType();
        for (Dependency object2 : type.getClientDependencies()) {
            if (!this.isTargetDependency(object2) || !list.contains(object2.getSuppliers().get(0))) continue;
            arrayList.add(object2);
        }
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        EditingDomain editingDomain = iJomtEntityStore.getDomain();
        try {
            CommandUtils.execute(editingDomain, DestroyCommand.create(editingDomain, arrayList));
        }
        catch (InterruptedException | RollbackException exception) {
            this.getLogger().error("error has occurred.", exception);
        }
    }

    protected boolean isTargetDependency(Dependency dependency) {
        return dependency instanceof Usage && StereotypeUtil.isUsage(dependency);
    }

    protected Port getPort() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
        if (modelTabGroup.getModelElement() instanceof Port) {
            return (Port)modelTabGroup.getModelElement();
        }
        return null;
    }

    protected List<Interface> getSeletedInterfaces() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
        Component component = modelTabGroup.getSelectedComponent();
        RequiredInterfaceTab requiredInterfaceTab = (RequiredInterfaceTab)component;
        return requiredInterfaceTab.getSelectedInterfaces();
    }

    protected Logger getLogger() {
        return a;
    }
}

