/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Component;
import java.util.List;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.ClassPropertyTab;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.uml2.uml.Property;

public class DeletePropertyFromPropViewCommand
extends Command {
    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            List<Property> list = this.getSeletedProperty();
            if (list == null) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                EditingDomain editingDomain = iJomtEntityStore.getDomain();
                CommandUtils.execute(editingDomain, DestroyCommand.create(editingDomain, list));
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected List<Property> getSeletedProperty() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
        Component component = modelTabGroup.getSelectedComponent();
        if (component instanceof ClassPropertyTab) {
            ClassPropertyTab classPropertyTab = (ClassPropertyTab)component;
            return classPropertyTab.getSelectedPropertyies();
        }
        return null;
    }
}

