/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import net.astah.emf.edit.command.CommandUtils;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.ClassGeneralizationTab;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.uml2.uml.Generalization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteGeneralizationFromPropViewCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(DeleteGeneralizationFromPropViewCommand.class);

    @Override
    public void execute() {
        List<Generalization> list = this.a();
        try {
            this.remove(list);
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(List<Generalization> list) {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        try {
            iJomtEntityStore.beginTransaction();
            EditingDomain editingDomain = iJomtEntityStore.getDomain();
            CommandUtils.execute(editingDomain, DestroyCommand.create(editingDomain, list));
            iJomtEntityStore.commitTransaction();
        }
        catch (BadTransactionException | RollbackException exception) {
            a.error("error has occurred.", exception);
            MessageManager.requireBugReport(exception);
            iJomtEntityStore.abortTransaction();
        }
        catch (Exception exception) {
            a.error("error has occurred.", exception);
            MessageManager.requireBugReport(exception);
        }
    }

    private List<Generalization> a() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
        Component component = modelTabGroup.getSelectedComponent();
        ArrayList<Generalization> arrayList = new ArrayList<Generalization>();
        if (!(component instanceof ClassGeneralizationTab)) {
            return arrayList;
        }
        if (component instanceof ClassGeneralizationTab) {
            ClassGeneralizationTab classGeneralizationTab = (ClassGeneralizationTab)component;
            return classGeneralizationTab.getSelectedGeneralizations();
        }
        return arrayList;
    }
}

