/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.DiagramElement;
import net.astah.dd.di.edit.command.DeleteDiagramElementCommand;
import net.astah.dd.di.edit.command.DiagramContext;
import net.astah.emf.common.ecore.EObjects;
import net.astah.emf.edit.job.CommandJob;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.util.Debug;
import net.astah.jmodel.AssociationPresentation;
import net.astah.jmodel.DurationConstraintPresentation;
import net.astah.jmodel.FramePresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.InstanceSpecificationLinkPresentation;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.PresentationUtil;
import net.astah.jmodel.QualifierBoxPresentation;
import net.astah.jmodel.SequenceMessageEndPresentation;
import net.astah.jmodel.TaggedValueUtilities;
import net.astah.jmodel.TimeConstraintPresentation;
import net.astah.jmodel.UserObject;
import net.astah.jomt.jcontrol.DeleteFromModelCommand;
import net.astah.jomt.jcontrol.s;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditor;
import net.astah.jomt.jview.MessageManager;
import net.astah.notation.mindmap.MMDiagramElement;
import net.astah.notation.mindmap.MMLabel;
import net.astah.notation.mindmap.MMLinkEdge;
import net.astah.notation.mindmap.MMTopicShape;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteFromDgmCommand
extends net.astah.golf.control.Command {
    private static final Logger a = LoggerFactory.getLogger(DeleteFromDgmCommand.class);
    protected DiagramElement[] presentations = null;
    protected Diagram dgm = null;
    protected boolean doTransaction = true;
    private boolean b = false;

    public void setPresentations(DiagramElement[] diagramElementArray) {
        this.presentations = diagramElementArray;
    }

    public void setDiagram(Diagram diagram) {
        this.dgm = diagram;
    }

    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            if (iJomtEntityStore == null) {
                return;
            }
            DiagramEditor diagramEditor = null;
            if (JomtGlobal.viewManager != null) {
                diagramEditor = JomtGlobal.viewManager.getCurrentDiagramEditor();
            }
            if (this.dgm == null && diagramEditor == null) {
                return;
            }
            if (this.presentations == null && diagramEditor != null) {
                this.presentations = diagramEditor.getSelectedPresentations();
            }
            this.presentations = this.getDeletingPresentation(this.presentations);
            if (this.presentations == null || this.presentations.length == 0) {
                return;
            }
            Set<EObject> set = this.getDeleteModels(diagramEditor);
            this.b(diagramEditor, set);
            if (this.dgm == null) {
                this.dgm = diagramEditor.getDiagram();
                if (this.dgm == null) {
                    Debug.impossible();
                }
            }
            if (EObjects.isReadOnly(this.dgm) || TaggedValueUtilities.isTraceabilityMap(this.dgm)) {
                return;
            }
            if (this.isReadOnlySpecialModel()) {
                return;
            }
            try {
                if (this.doTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                HashSet<EObject> hashSet = new HashSet<EObject>();
                for (DiagramElement diagramElement : this.presentations) {
                    hashSet.add(diagramElement);
                }
                for (EObject eObject : set) {
                    hashSet.add(eObject);
                }
                this.a(hashSet);
                if (this.doTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                a.error("error has occurred.", badTransactionException);
                MessageManager.requireBugReport(badTransactionException);
                if (this.doTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.doTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            this.b = true;
            a.error("error has occurred.", exception);
            MessageManager.requireBugReport(exception);
        }
    }

    protected boolean isReadOnlySpecialModel() {
        return false;
    }

    protected void callDeleteFromModelCommand() {
        DeleteFromModelCommand deleteFromModelCommand = this.getDeleteFromModelCommand();
        deleteFromModelCommand.setUseTransaction(this.doTransaction);
        deleteFromModelCommand.setDiagram(this.dgm);
        Set<EObject> set = this.getDeletePresentationModels();
        deleteFromModelCommand.setModels(set);
        deleteFromModelCommand.setFromDeleteFromDgm(true);
        this.callCommand(deleteFromModelCommand);
    }

    protected DeleteFromModelCommand getDeleteFromModelCommand() {
        return new DeleteFromModelCommand();
    }

    protected Set<EObject> getDeletePresentationModels() {
        HashSet<EObject> hashSet = new HashSet<EObject>();
        for (int i2 = 0; i2 < this.presentations.length; ++i2) {
            DiagramElement diagramElement = this.presentations[i2];
            if (!(diagramElement instanceof JomtPresentation) || ((JomtPresentation)diagramElement).getModel() == null) continue;
            hashSet.add(((JomtPresentation)diagramElement).getModel());
        }
        return hashSet;
    }

    protected DiagramElement[] getDeletingPresentation(DiagramElement[] diagramElementArray) {
        if (diagramElementArray == null) {
            return null;
        }
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>();
        for (int i2 = 0; i2 < diagramElementArray.length; ++i2) {
            if (diagramElementArray[i2] instanceof SequenceMessageEndPresentation || diagramElementArray[i2] instanceof FramePresentation || this.isSpecialTarget(diagramElementArray[i2])) continue;
            arrayList.add(diagramElementArray[i2]);
        }
        return arrayList.toArray(new DiagramElement[0]);
    }

    protected boolean isSpecialTarget(DiagramElement diagramElement) {
        if (diagramElement instanceof MMTopicShape) {
            return ((MMTopicShape)diagramElement).isRoot();
        }
        if (diagramElement instanceof MMLabel) {
            return diagramElement.getOwningElement() != null && diagramElement.getOwningElement() instanceof MMLinkEdge;
        }
        if (!(diagramElement instanceof LabelPresentation)) {
            return false;
        }
        LabelPresentation labelPresentation = (LabelPresentation)diagramElement;
        Presentation presentation = labelPresentation.getCompositeParent();
        if (presentation == null) {
            return false;
        }
        return !(presentation instanceof TimeConstraintPresentation) && !(presentation instanceof DurationConstraintPresentation) && !(presentation instanceof AssociationPresentation) && !(presentation instanceof InstanceSpecificationLinkPresentation);
    }

    public void setDoTransaction(boolean bl) {
        this.doTransaction = bl;
    }

    private void a(List<Presentation> list) {
        ArrayList<DiagramElement> arrayList = new ArrayList<DiagramElement>(Arrays.asList(this.presentations));
        for (int i2 = 0; i2 < this.presentations.length; ++i2) {
            if (list.contains(this.presentations[i2])) {
                arrayList.remove(this.presentations[i2]);
            }
            if (!(this.presentations[i2] instanceof QualifierBoxPresentation)) continue;
            arrayList.remove(this.presentations[i2]);
        }
        this.presentations = PresentationUtil.toPresentationArray(arrayList);
    }

    private List<Presentation> a(DiagramEditor diagramEditor, Collection<EObject> collection) {
        ArrayList<Presentation> arrayList = new ArrayList<Presentation>();
        if (diagramEditor != null) {
            Object[] objectArray = diagramEditor.getSelectedModels();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Presentation presentation;
                EObject eObject;
                Object object = objectArray[i2];
                if (!(object instanceof UserObject) || !collection.contains(eObject = ((UserObject)UserObject.class.cast(object)).getModel()) || arrayList.contains(presentation = ((UserObject)object).getPresentation())) continue;
                arrayList.add(presentation);
            }
        }
        return arrayList;
    }

    protected Set<EObject> getDeleteModels(DiagramEditor diagramEditor) {
        HashSet<EObject> hashSet = new HashSet<EObject>();
        if (diagramEditor == null) {
            return hashSet;
        }
        for (Object object : diagramEditor.getSelectedModels()) {
            EObject eObject;
            if (!(object instanceof UserObject) || (eObject = ((UserObject)object).getModel()) == null) continue;
            this.a(hashSet, eObject);
        }
        return hashSet;
    }

    private void a(Set<EObject> set, EObject eObject) {
        s s2 = new s(this, set);
        s2.doSwitch(eObject);
    }

    private void b(DiagramEditor diagramEditor, Collection<EObject> collection) {
        List<Presentation> list = this.a(diagramEditor, collection);
        this.a(list);
    }

    private void a(Set<EObject> set) {
        if (set == null || set.isEmpty()) {
            return;
        }
        if (set.stream().anyMatch(eObject -> eObject instanceof Presentation || eObject instanceof MMDiagramElement)) {
            DeleteFromModelCommand deleteFromModelCommand = new DeleteFromModelCommand();
            deleteFromModelCommand.setUseTransaction(false);
            deleteFromModelCommand.setModels(set);
            this.callCommand(deleteFromModelCommand);
        } else {
            TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(this.dgm);
            DiagramContext diagramContext = new DiagramContext(this.dgm, set, null);
            Command command = DeleteDiagramElementCommand.create((EditingDomain)transactionalEditingDomain, (Object)diagramContext, (Object)this.dgm, set);
            CommandJob commandJob = new CommandJob(transactionalEditingDomain, command);
            commandJob.schedule();
        }
    }

    public boolean isException() {
        return this.b;
    }

    public void reset() {
        this.presentations = null;
        this.dgm = null;
        this.event = null;
    }
}

