/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.StyleSupport;
import net.astah.jomt.jcontrol.DeleteFromModelCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import net.astah.jomt.jview.proptab.UseCaseExtensionPointTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.ExtensionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteExtensionPointFromPropViewCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(DeleteExtensionPointFromPropViewCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
            ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
            Component component = modelTabGroup.getSelectedComponent();
            if (!(component instanceof UseCaseExtensionPointTab)) {
                return;
            }
            UseCaseExtensionPointTab useCaseExtensionPointTab = (UseCaseExtensionPointTab)component;
            Iterator<ExtensionPoint> iterator = useCaseExtensionPointTab.getSelectedExtensionPoints();
            try {
                iJomtEntityStore.beginTransaction();
                while (iterator.hasNext()) {
                    ExtensionPoint extensionPoint = iterator.next();
                    HashSet<EObject> hashSet = new HashSet<EObject>();
                    hashSet.add(extensionPoint);
                    DeleteFromModelCommand deleteFromModelCommand = new DeleteFromModelCommand();
                    deleteFromModelCommand.setUseTransaction(false);
                    deleteFromModelCommand.setModels(hashSet);
                    this.callCommand(deleteFromModelCommand);
                    StyleSupport.clearSubItemIdInStyleMap(extensionPoint);
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                a.error("error has occurred.", badTransactionException);
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            a.error("error has occurred.", exception);
            MessageManager.requireBugReport(exception);
        }
    }
}

