/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.StyleSupport;
import net.astah.jomt.jcontrol.DeleteFromModelCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.EnumerationLiteralTab;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.EnumerationLiteral;

public class DeleteEnumerationLiteralFromPropViewCommand
extends Command {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
            ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
            Component component = modelTabGroup.getSelectedComponent();
            if (!(component instanceof EnumerationLiteralTab)) {
                return;
            }
            Iterator<EnumerationLiteral> iterator = this.getSeletedEnumerationLiterals();
            try {
                iJomtEntityStore.beginTransaction();
                while (iterator.hasNext()) {
                    EnumerationLiteral enumerationLiteral = iterator.next();
                    HashSet<EObject> hashSet = new HashSet<EObject>();
                    hashSet.add(enumerationLiteral);
                    DeleteFromModelCommand deleteFromModelCommand = new DeleteFromModelCommand();
                    deleteFromModelCommand.setUseTransaction(false);
                    deleteFromModelCommand.setModels(hashSet);
                    this.callCommand(deleteFromModelCommand);
                    StyleSupport.clearSubItemIdInStyleMap(enumerationLiteral);
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected Iterator<EnumerationLiteral> getSeletedEnumerationLiterals() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
        Component component = modelTabGroup.getSelectedComponent();
        EnumerationLiteralTab enumerationLiteralTab = (EnumerationLiteralTab)component;
        return enumerationLiteralTab.getSelectedEnumerationLiterals();
    }
}

