/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import lombok.NonNull;
import net.astah.emf.common.transaction.Transactions;
import net.astah.emf.edit.command.DestroyCommand;
import net.astah.emf.edit.job.CommandJob;
import net.astah.jomt.jcontrol.r;
import net.astah.jomt.jsystem.SystemProperty;
import net.astah.jomt.jutil.SwingInvoker;
import net.astah.jomt.jview.MessageManager;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteConfirmationListener
extends JobChangeAdapter {
    private static final Logger a = LoggerFactory.getLogger(DeleteConfirmationListener.class);

    public IDisposable observe(@NonNull SystemProperty systemProperty) {
        if (systemProperty == null) {
            throw new NullPointerException("systemProperty");
        }
        return new a(systemProperty, null);
    }

    @Override
    public void aboutToRun(IJobChangeEvent iJobChangeEvent) {
        Job job = iJobChangeEvent.getJob();
        if (job instanceof CommandJob && !this.shouldRun((CommandJob)job)) {
            a.debug("The job {} has been canceled by user", job);
            job.cancel();
        }
    }

    protected boolean shouldRun(CommandJob commandJob) {
        try {
            TransactionalEditingDomain transactionalEditingDomain = commandJob.getDomain();
            Command command = commandJob.getCommand();
            return Transactions.runExclusive(transactionalEditingDomain, () -> this.a(command)) != false || SwingInvoker.runInEDTAndWait(() -> this.b(command)) != false;
        }
        catch (InterruptedException interruptedException) {
            a.debug("Interrupted", interruptedException);
        }
        catch (ExecutionException executionException) {
            a.warn("Failed to determine user intension", executionException);
        }
        return true;
    }

    private boolean a(Command command) {
        return !command.canExecute() || DestroyCommand.isIntended(command);
    }

    private boolean a(SystemProperty systemProperty) {
        return systemProperty.getBooleanWithDefault("basic.confirm_deleting_elements_on_diagram");
    }

    private boolean b(Command command) {
        return MessageManager.displayYesNoDialog("app", "delete_model_for_presentations.message") == 0;
    }

    private class a
    implements PropertyChangeListener,
    IDisposable {
        private final SystemProperty b;
        private boolean c;

        private a(SystemProperty systemProperty) {
            this.b = systemProperty;
            systemProperty.addPropertyChangeListener(this);
            this.a();
        }

        @Override
        public void dispose() {
            this.b.removePropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.a();
        }

        protected void a() {
            IJobManager iJobManager = Job.getJobManager();
            if (DeleteConfirmationListener.this.a(this.b)) {
                if (!this.c) {
                    iJobManager.addJobChangeListener(DeleteConfirmationListener.this);
                    this.c = true;
                }
            } else if (this.c) {
                iJobManager.removeJobChangeListener(DeleteConfirmationListener.this);
                this.c = false;
            }
        }

        /* synthetic */ a(SystemProperty systemProperty, r r2) {
            this(systemProperty);
        }
    }
}

