/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.StyleSupport;
import net.astah.jomt.jcontrol.DeleteFromModelCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.ClassAttributeTab;
import net.astah.jomt.jview.proptab.ModelTabGroup;
import net.astah.jomt.jview.proptab.QualifierBoxAttributeTab;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Property;

public class DeleteAttributeFromPropViewCommand
extends Command {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            Iterator<Property> iterator = this.getSeletedAttributes();
            if (iterator == null) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                while (iterator.hasNext()) {
                    Property property = iterator.next();
                    HashSet<EObject> hashSet = new HashSet<EObject>();
                    hashSet.add(property);
                    DeleteFromModelCommand deleteFromModelCommand = new DeleteFromModelCommand();
                    deleteFromModelCommand.setUseTransaction(false);
                    deleteFromModelCommand.setModels(hashSet);
                    this.callCommand(deleteFromModelCommand);
                    StyleSupport.clearSubItemIdInStyleMap(property);
                }
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    protected Iterator<Property> getSeletedAttributes() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTabGroup modelTabGroup = propertyView.getModelPane().getCurrentModelTabGroup();
        Component component = modelTabGroup.getSelectedComponent();
        if (component instanceof ClassAttributeTab) {
            ClassAttributeTab classAttributeTab = (ClassAttributeTab)component;
            return classAttributeTab.getSelectedAttributes();
        }
        if (component instanceof QualifierBoxAttributeTab) {
            QualifierBoxAttributeTab qualifierBoxAttributeTab = (QualifierBoxAttributeTab)component;
            return qualifierBoxAttributeTab.getSelectedAttributes();
        }
        return null;
    }
}

