/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.SequenceDestructionPresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jmodel.UMLSequenceDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.OccurrenceSpecifications;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.DestructionOccurrenceSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;

public class CreateTerminationCommand
extends Command {
    private SequenceDestructionPresentation b;
    LifelinePresentation a = null;
    private UMLDiagram c;
    private String d = null;
    private boolean e = false;

    public void setPresentation(SequenceDestructionPresentation sequenceDestructionPresentation) {
        this.b = sequenceDestructionPresentation;
    }

    public void setModelName(String string) {
        this.d = string;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.c = uMLDiagram;
    }

    public void setShiftPressedState(boolean bl) {
        this.e = bl;
    }

    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        if (!(this.c instanceof UMLSequenceDiagram)) {
            return;
        }
        if (this.a == null) {
            return;
        }
        UMLSequenceDiagram uMLSequenceDiagram = (UMLSequenceDiagram)this.c;
        Lifeline lifeline = this.a.getClassifierRole();
        EList<InteractionFragment> eList = lifeline.getCoveredBys();
        for (InteractionFragment interactionFragment : eList) {
            if (!(interactionFragment instanceof DestructionOccurrenceSpecification)) continue;
            MessageManager.displayAlertMessageDialog("uml", "termination_exists.message");
            return;
        }
        try {
            if (this.b == null || iJomtEntityStore == null || this.c == null) {
                return;
            }
            try {
                InteractionFragment interactionFragment;
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                String string = PropertyManager.getProjectViewResourceBundle().getString("uml.termination.label") + project.terminationNum++;
                interactionFragment = OccurrenceSpecifications.createDestructionOccurrenceSpecification(lifeline);
                interactionFragment.setName(string);
                this.b.getCovereds().add(this.a);
                this.a.updateTermination();
                ElementPresentations.addPresentation(interactionFragment, this.b, uMLSequenceDiagram);
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.e);
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    public void setClassifierRolePresentation(LifelinePresentation lifelinePresentation) {
        this.a = lifelinePresentation;
    }
}

