/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.StereotypeUtil;
import net.astah.jomt.jcontrol.CreateRelationCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Elements;
import net.astah.uml2.uml.TemplateBindings;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.TemplateBinding;

public class CreateTemplateBindingCommand
extends CreateRelationCommand {
    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        try {
            if (this.relationPs == null || iJomtEntityStore == null || this.startPs == null || this.endPs == null) {
                return;
            }
            if (!this.checkValid()) {
                return;
            }
            try {
                if (this.needTran) {
                    iJomtEntityStore.beginTransaction();
                }
                Element element = this.createRelation(iJomtEntityStore);
                iJomtEntityStore.addEntity(this.relationPs);
                this.relationPs.setSourcePresentation(this.startPs);
                this.relationPs.setTargetPresentation(this.endPs);
                if (this.startPs instanceof LabelPresentation) {
                    ((LabelPresentation)this.startPs).resize();
                }
                if (this.relationPs instanceof LabelPresentation) {
                    ((LabelPresentation)((Object)this.relationPs)).resize();
                }
                CreateTemplateBindingCommand.setRightAngle(this.relationPs);
                ElementPresentations.addPresentation(element, this.relationPs, this.dgm);
                Elements.compareStereotypeAndsetTagValue(element);
                if (this.needTran) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.needTran) {
                    this.model = null;
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.needTran) {
                    this.model = null;
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
            finally {
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }

    @Override
    protected Element createRelation(IEntityStore iEntityStore) {
        Classifier classifier = null;
        if (this.startPs != null) {
            classifier = (Classifier)this.startPs.getModel();
            this.relationPs.setSourcePresentation(this.startPs);
        } else if (this.startModel != null) {
            classifier = (Classifier)this.startModel;
        }
        Classifier classifier2 = null;
        if (this.endPs != null) {
            classifier2 = (Classifier)this.endPs.getModel();
            this.relationPs.setTargetPresentation(this.endPs);
        } else if (this.endModel != null) {
            classifier2 = (Classifier)this.endModel;
        }
        Relationship relationship = this.getRelationModelForAPI();
        if (relationship instanceof TemplateBinding) {
            return relationship;
        }
        if (classifier != null && classifier2 != null) {
            TemplateBinding templateBinding = TemplateBindings.createTemplateBinding(classifier, classifier2);
            if (this.startPs != null && StereotypeUtil.isInterface(classifier)) {
                this.a((ClassifierPresentation)this.startPs);
                ((ClassifierPresentation)this.startPs).changeEndPointForIF();
            }
            if (this.endPs != null && StereotypeUtil.isInterface(classifier2)) {
                this.a((ClassifierPresentation)this.endPs);
                ((ClassifierPresentation)this.endPs).changeEndPointForIF();
            }
            return templateBinding;
        }
        return null;
    }

    private void a(ClassifierPresentation classifierPresentation) {
        for (Presentation presentation : classifierPresentation.getPartner()) {
            if (((ClassifierPresentation)presentation).getNotationType() != 1) continue;
            if (classifierPresentation == this.startPs) {
                this.startPs = (ClassifierPresentation)presentation;
                break;
            }
            this.endPs = (ClassifierPresentation)presentation;
            break;
        }
    }
}

