/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.LifelinePresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.UMLInteractionDiagram;
import net.astah.jomt.jcontrol.CreateInteractionFragmentCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jsystem.PropertyManager;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Constraints;
import net.astah.uml2.uml.Elements;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.StateInvariant;
import org.eclipse.uml2.uml.UMLFactory;

public class CreateStateInvariantCommand
extends CreateInteractionFragmentCommand {
    protected LabelPresentation p;

    @Override
    public void setPresentation(LabelPresentation labelPresentation) {
        super.setPresentation(labelPresentation);
        this.p = labelPresentation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        Lifeline lifeline = (Lifeline)((LifelinePresentation)this.coveredLifelines.get(0)).getModel();
        if (this.p == null || iJomtEntityStore == null || this.dgm == null || lifeline == null) {
            return;
        }
        if (this.isBelowTermination()) {
            MessageManager.displayAlertMessageDialog("uml", "stateinvariant_cannot_below_termination.message");
            return;
        }
        try {
            if (this.useTransaction) {
                iJomtEntityStore.beginTransaction();
            }
            UMLInteractionDiagram uMLInteractionDiagram = (UMLInteractionDiagram)this.dgm;
            Interaction interaction = uMLInteractionDiagram.getInteraction();
            StateInvariant stateInvariant = this.a(interaction);
            Constraint constraint = stateInvariant.createInvariant(null);
            Constraints.setExpression(constraint, stateInvariant.getName());
            this.a(stateInvariant);
            ElementPresentations.addPresentation(stateInvariant, this.p, this.dgm);
            this.p.setBodyColorWithDefault();
            Elements.compareStereotypeAndsetTagValue(stateInvariant);
            JomtDefaultSizeUtilities jomtDefaultSizeUtilities = ReflectionUtil.getJomtDefaultSizeUtilities(this.p);
            if (jomtDefaultSizeUtilities.getDefaultUse()) {
                this.p.setDoAutoResize(false);
                this.p.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
                this.p.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
            } else {
                this.p.setDoAutoResize(true);
                this.p.resize();
                this.p.setDoAutoResize(false);
            }
            if (this.useTransaction) {
                iJomtEntityStore.commitTransaction();
            }
            if (JomtGlobal.modeManager != null) {
                JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
            }
        }
        catch (BadTransactionException badTransactionException) {
            MessageManager.requireBugReport(badTransactionException);
            if (this.useTransaction) {
                iJomtEntityStore.abortTransaction();
            }
        }
        catch (Exception exception) {
            if (this.useTransaction) {
                iJomtEntityStore.abortTransaction();
            }
            MessageManager.requireBugReport(exception);
        }
    }

    private void a(StateInvariant stateInvariant) {
        for (Presentation presentation : this.coveredLifelines) {
            if (!(presentation instanceof LifelinePresentation)) continue;
            LifelinePresentation lifelinePresentation = (LifelinePresentation)presentation;
            Lifeline lifeline = lifelinePresentation.getClassifierRole();
            stateInvariant.getCovereds().add(lifeline);
        }
    }

    private StateInvariant a(Interaction interaction) {
        String string = PropertyManager.getProjectViewResourceBundle().getString("uml.StateInvariant.label");
        StateInvariant stateInvariant = (StateInvariant)interaction.createFragment(string, UMLFactory.eINSTANCE.createStateInvariant().eClass());
        return stateInvariant;
    }
}

