/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.BinaryRelationPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.Project;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.DiagramEditorUtil;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.IllegalModelTypeException;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Elements;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Relationship;

public abstract class CreateRelationCommand
extends Command {
    protected BinaryRelationPresentation relationPs = null;
    protected Relationship relationModel = null;
    protected JomtPresentation startPs;
    protected JomtPresentation endPs;
    protected Element startModel;
    protected Element endModel;
    protected String name = null;
    protected UMLDiagram dgm;
    protected boolean needTran = true;
    protected boolean isShiftPressed = false;
    protected boolean isBeginTransaction = true;
    protected boolean isCommitTransaction = true;
    protected Element model;
    protected Element relation;
    protected boolean isBadTransactionException = false;
    protected boolean isException = false;

    public Element getRelation() {
        return this.relation;
    }

    public Element getModel() {
        return this.model;
    }

    public void setBeginTransaction(boolean bl) {
        this.isBeginTransaction = bl;
    }

    public void setCommitTransaction(boolean bl) {
        this.isCommitTransaction = bl;
    }

    public void setTransaction(boolean bl) {
        this.needTran = bl;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.dgm = uMLDiagram;
    }

    public void setPresentation(BinaryRelationPresentation binaryRelationPresentation) {
        this.relationPs = binaryRelationPresentation;
    }

    public BinaryRelationPresentation getPresentation() {
        return this.relationPs;
    }

    public void setStartPresentation(JomtPresentation jomtPresentation) {
        this.startPs = jomtPresentation;
    }

    public void setEndPresentation(JomtPresentation jomtPresentation) {
        this.endPs = jomtPresentation;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        try {
            if (!this.checkValid()) {
                return;
            }
            try {
                if (this.needTran && this.isBeginTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                this.createNewRelation(iJomtEntityStore);
                if (this.needTran && this.isCommitTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
                this.postCreate();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (this.needTran) {
                    this.model = null;
                    iJomtEntityStore.abortTransaction();
                }
                this.isBadTransactionException = true;
            }
            catch (IllegalModelTypeException illegalModelTypeException) {
                MessageManager.requireBugReport(illegalModelTypeException);
                if (this.needTran) {
                    this.model = null;
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                if (this.needTran) {
                    this.model = null;
                    iJomtEntityStore.abortTransaction();
                }
            }
            catch (Exception exception) {
                if (this.needTran) {
                    this.model = null;
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
            finally {
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                }
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
            this.isException = true;
        }
    }

    protected void postCreate() {
    }

    public void createNewRelation(IEntityStore iEntityStore) throws IllegalModelTypeException {
        this.relation = this.createRelation(iEntityStore);
        if (this.relationPs != null && iEntityStore != null && this.startPs != null && this.endPs != null) {
            if (this.relationPs.getSourcePresentation() == null) {
                this.relationPs.setSourcePresentation(this.startPs);
            }
            if (this.relationPs.getTargetPresentation() == null) {
                this.relationPs.setTargetPresentation(this.endPs);
            }
            ElementPresentations.addPresentation(this.relation, this.relationPs, this.dgm);
            CreateRelationCommand.setRightAngle(this.relationPs);
        }
        Elements.compareStereotypeAndsetTagValue(this.relation);
    }

    protected static void setRightAngle(BinaryRelationPresentation binaryRelationPresentation) {
        DiagramEditorUtil.setInitialLineShape(binaryRelationPresentation);
    }

    public void createRelationAndEnsureWellFormed(IEntityStore iEntityStore) {
        this.relation = this.createRelation(iEntityStore);
        Elements.compareStereotypeAndsetTagValue(this.relation);
    }

    protected boolean checkValid() {
        return true;
    }

    protected abstract Element createRelation(IEntityStore var1);

    public void setStartModel(Element element) {
        this.startModel = element;
    }

    public void setEndModel(Element element) {
        this.endModel = element;
    }

    public void setName(String string) {
        this.name = string;
    }

    public EObject getEndModel() {
        return this.endPs.getModel();
    }

    public EObject getStartModel() {
        return this.startPs.getModel();
    }

    public boolean isBadTransactionException() {
        return this.isBadTransactionException;
    }

    public boolean isException() {
        return this.isException;
    }

    public Relationship getRelationModelForAPI() {
        return this.relationModel;
    }

    public void setRelationModelForAPI(Relationship relationship) {
        this.relationModel = relationship;
    }
}

