/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.BinaryRelationPresentation;
import net.astah.jmodel.ClassifierPresentation;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.JomtPresentation;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.PartPresentation;
import net.astah.jmodel.Presentation;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.DiagramEditorUtil;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Type;

public abstract class CreatePropertyCommand
extends Command {
    protected Presentation p;
    protected UMLDiagram dgm;
    protected boolean isShiftPressed = false;
    protected JomtPresentation parent;
    protected String modelName;
    protected Classifier ownerClassifier;
    protected Type type;
    protected Property createdProperty = null;

    public Property getCreatedProperty() {
        return this.createdProperty;
    }

    public void setModelName(String string) {
        this.modelName = string;
    }

    public void setOwnerClass(Classifier classifier) {
        this.ownerClassifier = classifier;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setPresentation(Presentation presentation) {
        this.p = presentation;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.dgm = uMLDiagram;
    }

    public void setParent(JomtPresentation jomtPresentation) {
        this.parent = jomtPresentation;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() {
        IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
        if (this.parent == null || this.p == null || iJomtEntityStore == null || this.dgm == null) {
            return;
        }
        if (!this.selectPropertyType()) {
            return;
        }
        Classifier classifier = null;
        EObject eObject = this.parent.getModel();
        if (eObject instanceof Classifier) {
            classifier = (Classifier)this.parent.getModel();
        } else if (eObject instanceof StructuralFeature) {
            classifier = (Classifier)((StructuralFeature)eObject).getType();
        }
        while (true) {
            Property property = null;
            try {
                Namespace namespace;
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                if ((property = this.createNewProperty(iJomtEntityStore, namespace = classifier.getNamespace(), classifier)) == null && this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                    return;
                }
                iJomtEntityStore.addEntity(this.p);
                ElementPresentations.addPresentation(property, this.p, this.dgm);
                this.setStereotypeVisibility();
                ((RectPresentation)this.p).setBodyColorWithDefault();
                this.a((LabelPresentation)this.p);
                this.a();
                this.a(property, iJomtEntityStore);
                if (!this.useTransaction) break;
                iJomtEntityStore.commitTransaction();
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                if (!this.useTransaction) continue;
                iJomtEntityStore.abortTransaction();
                continue;
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                if (!this.useTransaction) break;
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                MessageManager.requireBugReport(exception);
            }
            break;
        }
        this.postOperation();
    }

    protected boolean selectPropertyType() {
        return true;
    }

    protected void setStereotypeVisibility() {
    }

    private void a() {
        if (this.parent instanceof ClassifierPresentation) {
            ClassifierPresentation classifierPresentation = (ClassifierPresentation)this.parent;
            PartPresentation partPresentation = (PartPresentation)this.p;
            partPresentation.setContainer(classifierPresentation);
        } else if (this.parent instanceof PartPresentation) {
            PartPresentation partPresentation = (PartPresentation)this.parent;
            PartPresentation partPresentation2 = (PartPresentation)this.p;
            partPresentation2.setContainer(partPresentation);
        }
    }

    protected void postOperation() {
        if (JomtGlobal.modeManager != null) {
            JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
        }
    }

    protected abstract Property createNewProperty(IEntityStore var1, Namespace var2, Classifier var3);

    private void a(Property property, IEntityStore iEntityStore) {
    }

    private void a(BinaryRelationPresentation binaryRelationPresentation) {
        DiagramEditorUtil.setInitialLineShape(binaryRelationPresentation);
    }

    private void a(LabelPresentation labelPresentation) {
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = this.createDefaultSizeUtilities(labelPresentation);
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            labelPresentation.setDoAutoResize(false);
            labelPresentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
            labelPresentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
        } else {
            this.setDefaultPresentationSize(labelPresentation);
        }
    }

    protected void setDefaultPresentationSize(LabelPresentation labelPresentation) {
        labelPresentation.setDoAutoResize(true);
        labelPresentation.resize();
    }

    protected JomtDefaultSizeUtilities createDefaultSizeUtilities(LabelPresentation labelPresentation) {
        return ReflectionUtil.getJomtDefaultSizeUtilities(labelPresentation);
    }
}

