/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.dd.di.DIPackage;
import net.astah.dd.di.Diagram;
import net.astah.dd.di.Shape;
import net.astah.emf.edit.job.CommandJob;
import net.astah.emf.edit.job.Jobs;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.PolyLinePresentation;
import net.astah.jmodel.Project;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.DiagramEditors;
import net.astah.jomt.jview.MessageManager;
import net.astah.model.operations.DiagramOperations;
import net.astah.uml.exception.IllegalModelTypeException;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;

public class CreatePolyLineCommand
extends Command {
    private Shape a;
    private Diagram b;
    private boolean c = false;

    public void setPresentation(Shape shape) {
        this.a = shape;
    }

    public void setDiagram(Diagram diagram) {
        this.b = diagram;
    }

    public void setShiftPressedState(boolean bl) {
        this.c = bl;
    }

    @Override
    public void execute() {
        try {
            Project project = ModelGlobal.prjManager.getCurrentProject();
            IJomtEntityStore iJomtEntityStore = project.doc;
            if (this.a == null || iJomtEntityStore == null || this.b == null) {
                return;
            }
            if (this.a instanceof PolyLinePresentation) {
                try {
                    iJomtEntityStore.beginTransaction();
                    PolyLinePresentation polyLinePresentation = (PolyLinePresentation)this.a;
                    iJomtEntityStore.addEntity(polyLinePresentation);
                    DiagramOperations.addPresentation(this.b, polyLinePresentation, null);
                    iJomtEntityStore.commitTransaction();
                }
                catch (BadTransactionException badTransactionException) {
                    MessageManager.requireBugReport(badTransactionException);
                    iJomtEntityStore.abortTransaction();
                }
                catch (IllegalModelTypeException illegalModelTypeException) {
                    MessageManager.requireBugReport(illegalModelTypeException);
                    iJomtEntityStore.abortTransaction();
                }
                catch (Exception exception) {
                    iJomtEntityStore.abortTransaction();
                    throw exception;
                }
            } else {
                TransactionalEditingDomain transactionalEditingDomain = TransactionUtil.getEditingDomain(this.b);
                CommandJob commandJob = new CommandJob(transactionalEditingDomain, AddCommand.create((EditingDomain)transactionalEditingDomain, (Object)this.b, (Object)DIPackage.Literals.DIAGRAM_ELEMENT__OWNED_ELEMENT, this.a, 0));
                Jobs.toCompletableFuture(commandJob, true).thenRun(() -> DiagramEditors.selectOnCurrentEditor(this.a));
                commandJob.schedule();
            }
            JomtGlobal.modeManager.changeButtonsState(this.c);
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
    }
}

