/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.PackageFactory;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.uml.Elements;
import org.eclipse.uml2.uml.Package;

public class CreatePackageFromPrjCommand
extends Command {
    protected Package model;
    protected Package newPackage;

    public void setParent(Package package_) {
        this.model = package_;
    }

    public Package getNewPackage() {
        return this.newPackage;
    }

    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        int n2 = 100;
        while (n2-- > 0) {
            try {
                if (this.model == null) {
                    this.getModel();
                }
                try {
                    iJomtEntityStore.beginTransaction();
                    this.createNewPackage(this.model, null);
                    iJomtEntityStore.commitTransaction();
                    JomtGlobal.commandSupport.startEditing(this.newPackage);
                    break;
                }
                catch (UMLSemanticsException uMLSemanticsException) {
                    iJomtEntityStore.abortTransaction();
                }
                catch (BadTransactionException badTransactionException) {
                    MessageManager.requireBugReport(badTransactionException);
                    iJomtEntityStore.abortTransaction();
                    break;
                }
                catch (Exception exception) {
                    iJomtEntityStore.abortTransaction();
                    throw exception;
                }
            }
            catch (Exception exception) {
                MessageManager.requireBugReport(exception);
            }
        }
    }

    public void createNewPackage(Package package_, String string) {
        if (this.model == null) {
            this.setParent(package_);
        }
        this.newPackage = PackageFactory.createPackage(this.model);
        if (string != null) {
            this.newPackage.setName(string);
        }
        Elements.compareStereotypeAndsetTagValue(this.newPackage);
    }

    protected void getModel() {
        this.model = (Package)JomtGlobal.commandSupport.getSelectedModelElementFromProjectView();
    }
}

