/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.PackagePresentation;
import net.astah.jmodel.PresentationContainer;
import net.astah.jmodel.Project;
import net.astah.jmodel.RectPresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jcontrol.PackageFactory;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml.exception.UMLSemanticsException;
import net.astah.uml2.operations.ElementPresentations;
import net.astah.uml2.uml.Elements;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;

public class CreatePackageCommand
extends Command {
    protected PackagePresentation p = null;
    protected UMLDiagram dgm;
    protected RectPresentation parent = null;
    protected boolean isShiftPressed = false;
    protected Package newPackage = null;

    @Override
    public void setArgumentString(String string) {
    }

    public void setPresentation(PackagePresentation packagePresentation) {
        this.p = packagePresentation;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.dgm = uMLDiagram;
    }

    public void setParent(RectPresentation rectPresentation) {
        this.parent = rectPresentation;
    }

    public void setShiftPressedState(boolean bl) {
        this.isShiftPressed = bl;
    }

    @Override
    public void execute() {
        int n2 = 100;
        while (n2-- > 0) {
            try {
                Project project = ModelGlobal.prjManager.getCurrentProject();
                IJomtEntityStore iJomtEntityStore = project.doc;
                if (this.p == null || iJomtEntityStore == null || this.dgm == null) {
                    return;
                }
                try {
                    Namespace namespace;
                    if (this.useTransaction) {
                        iJomtEntityStore.beginTransaction();
                    }
                    Package package_ = null;
                    if (this.parent == null) {
                        for (namespace = (Namespace)this.dgm.getParent(); namespace != null; namespace = namespace.getNamespace()) {
                            if (!(namespace instanceof Package)) continue;
                            package_ = (Package)namespace;
                            break;
                        }
                    } else {
                        package_ = (Package)this.parent.getModel();
                        this.p.setContainer((PresentationContainer)this.parent);
                    }
                    namespace = this.newPackage;
                    if (namespace == null) {
                        namespace = PackageFactory.createPackage(package_);
                    } else if (this.parent != null) {
                        namespace.setNestingPackage(package_);
                    }
                    iJomtEntityStore.addEntity(this.p);
                    ElementPresentations.addPresentation(namespace, this.p, this.dgm);
                    this.p.setBodyColorWithDefault();
                    if (package_ == null) {
                        return;
                    }
                    this.a(this.p);
                    Elements.compareStereotypeAndsetTagValue(namespace);
                    if (this.useTransaction) {
                        iJomtEntityStore.commitTransaction();
                    }
                    if (JomtGlobal.modeManager == null) break;
                    JomtGlobal.modeManager.changeButtonsState(this.isShiftPressed);
                    break;
                }
                catch (UMLSemanticsException uMLSemanticsException) {
                    if (!this.useTransaction) continue;
                    iJomtEntityStore.abortTransaction();
                }
                catch (BadTransactionException badTransactionException) {
                    MessageManager.requireBugReport(badTransactionException);
                    if (!this.useTransaction) break;
                    iJomtEntityStore.abortTransaction();
                    break;
                }
                catch (Exception exception) {
                    if (this.useTransaction) {
                        iJomtEntityStore.abortTransaction();
                    }
                    throw exception;
                }
            }
            catch (Exception exception) {
                MessageManager.requireBugReport(exception);
            }
        }
    }

    private void a(LabelPresentation labelPresentation) {
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = ReflectionUtil.getJomtDefaultSizeUtilities(labelPresentation);
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            labelPresentation.setDoAutoResize(false);
            labelPresentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
            labelPresentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
        } else {
            labelPresentation.setDoAutoResize(true);
            labelPresentation.resize();
            labelPresentation.setDoAutoResize(false);
        }
    }

    public void setModel(Package package_) {
        this.newPackage = package_;
    }
}

