/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.util.Debug;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.LabelPresentation;
import net.astah.jmodel.NotePresentation;
import net.astah.jmodel.UMLDiagram;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jutil.JomtDefaultSizeUtilities;
import net.astah.jomt.jutil.ReflectionUtil;
import net.astah.jomt.jview.MessageManager;
import net.astah.uml2.operations.ElementPresentations;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNoteCommand
extends Command {
    private static final Logger a = LoggerFactory.getLogger(CreateNoteCommand.class);
    private NotePresentation b = null;
    private UMLDiagram c;
    private boolean d = false;
    private Comment e;
    private String f = "";
    private boolean g = false;
    private boolean h = false;

    public void setBodyText(String string) {
        this.f = string;
    }

    public Comment getModel() {
        return this.e;
    }

    public void setPresentation(NotePresentation notePresentation) {
        this.b = notePresentation;
    }

    public void setShiftPressedState(boolean bl) {
        this.d = bl;
    }

    public void setDiagram(UMLDiagram uMLDiagram) {
        this.c = uMLDiagram;
    }

    @Override
    public void execute() {
        try {
            IJomtEntityStore iJomtEntityStore = ModelGlobal.prjManager.getCurrentProject().doc;
            if (this.b == null || iJomtEntityStore == null || this.c == null) {
                Debug.impossible("impossible action.  CreateNoteCommand#execute(): parameter error");
                return;
            }
            try {
                if (this.useTransaction) {
                    iJomtEntityStore.beginTransaction();
                }
                Element element = this.a(this.c);
                this.e = element.createOwnedComment();
                this.addOptionalStereotype();
                if (this.f != null) {
                    this.e.setBody(this.f);
                }
                iJomtEntityStore.addEntity(this.b);
                ElementPresentations.addPresentation(this.e, this.b, this.c);
                this.b.setBodyColorWithDefault();
                this.a(this.b);
                if (this.useTransaction) {
                    iJomtEntityStore.commitTransaction();
                }
                if (JomtGlobal.modeManager != null) {
                    JomtGlobal.modeManager.changeButtonsState(this.d);
                }
            }
            catch (BadTransactionException badTransactionException) {
                a.error("error has occurred.", badTransactionException);
                MessageManager.requireBugReport(badTransactionException);
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                this.g = true;
            }
            catch (Exception exception) {
                if (this.useTransaction) {
                    iJomtEntityStore.abortTransaction();
                }
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
            this.h = true;
        }
    }

    private Element a(UMLDiagram uMLDiagram) {
        return (Element)Element.class.cast(uMLDiagram.getParent());
    }

    protected void addOptionalStereotype() {
    }

    private void a(LabelPresentation labelPresentation) {
        JomtDefaultSizeUtilities jomtDefaultSizeUtilities = ReflectionUtil.getJomtDefaultSizeUtilities(labelPresentation);
        if (jomtDefaultSizeUtilities.getDefaultUse()) {
            labelPresentation.setDoAutoResize(false);
            labelPresentation.setWidth(jomtDefaultSizeUtilities.getDefaultWidth());
            labelPresentation.setHeight(jomtDefaultSizeUtilities.getDefaultHeight());
        } else {
            labelPresentation.setDoAutoResize(true);
            labelPresentation.resize();
            labelPresentation.setDoAutoResize(false);
        }
    }

    public boolean isBadTransactionException() {
        return this.g;
    }

    public boolean isException() {
        return this.h;
    }
}

