/*
 * Decompiled with CFR 0.152.
 */
package net.astah.jomt.jcontrol;

import java.util.ArrayList;
import java.util.List;
import net.astah.emf.common.ecore.EObjects;
import net.astah.golf.control.Command;
import net.astah.golf.model.BadTransactionException;
import net.astah.golf.model.IEntityStore;
import net.astah.jmodel.IJomtEntityStore;
import net.astah.jmodel.Project;
import net.astah.jomt.jcontrol.OpenNewAssociationPropertyViewCommand;
import net.astah.jomt.jsystem.JomtGlobal;
import net.astah.jomt.jsystem.ModelGlobal;
import net.astah.jomt.jview.MessageManager;
import net.astah.jomt.jview.PropertyView;
import net.astah.jomt.jview.proptab.ConnectorBaseTab;
import net.astah.jomt.jview.proptab.ModelTab;
import net.astah.uml.exception.UMLSemanticsException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.VisibilityKind;

public class CreateNewTypeForConnectorCommand
extends Command {
    protected Association newType;

    @Override
    public void execute() {
        Project project = ModelGlobal.prjManager.getCurrentProject();
        IJomtEntityStore iJomtEntityStore = project.doc;
        try {
            if (!this.checkValid()) {
                return;
            }
            try {
                iJomtEntityStore.beginTransaction();
                this.newType = this.createAssociation(iJomtEntityStore);
                iJomtEntityStore.commitTransaction();
            }
            catch (BadTransactionException badTransactionException) {
                MessageManager.requireBugReport(badTransactionException);
                iJomtEntityStore.abortTransaction();
            }
            catch (UMLSemanticsException uMLSemanticsException) {
                MessageManager.displayAlertMessageDialog("uml", uMLSemanticsException.getMessage());
                iJomtEntityStore.abortTransaction();
            }
            catch (Exception exception) {
                iJomtEntityStore.abortTransaction();
                throw exception;
            }
        }
        catch (Exception exception) {
            MessageManager.requireBugReport(exception);
        }
        this.postCreating();
    }

    protected void postCreating() {
        if (this.newType == null) {
            return;
        }
        ModelTab modelTab = this.getModelTab();
        ConnectorBaseTab connectorBaseTab = (ConnectorBaseTab)modelTab;
        connectorBaseTab.updateTypeItems();
        connectorBaseTab.selectType(this.newType);
        OpenNewAssociationPropertyViewCommand openNewAssociationPropertyViewCommand = new OpenNewAssociationPropertyViewCommand();
        openNewAssociationPropertyViewCommand.setModel(this.newType);
        this.callCommand(openNewAssociationPropertyViewCommand);
    }

    protected ModelTab getModelTab() {
        PropertyView propertyView = JomtGlobal.viewManager.getCurrentPropertyView();
        ModelTab modelTab = propertyView.getModelPane().getCurrentModelTabGroup().getCurrentModelTab();
        return modelTab;
    }

    protected boolean checkValid() {
        return true;
    }

    private Connector a() {
        ModelTab modelTab = this.getModelTab();
        ConnectorBaseTab connectorBaseTab = (ConnectorBaseTab)modelTab;
        Connector connector = (Connector)connectorBaseTab.getModel();
        return connector;
    }

    private List<Type> a(Connector connector) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        EList<ConnectorEnd> eList = connector.getEnds();
        ConnectorEnd connectorEnd = (ConnectorEnd)eList.get(0);
        ConnectorEnd connectorEnd2 = (ConnectorEnd)eList.get(1);
        Type type = connectorEnd.getRole().getType();
        Type type2 = connectorEnd2.getRole().getType();
        arrayList.add(type);
        arrayList.add(type2);
        return arrayList;
    }

    protected Association createAssociation(IEntityStore iEntityStore) {
        boolean bl;
        Connector connector = this.a();
        List<Type> list = this.a(connector);
        Type type = list.get(0);
        Type type2 = list.get(1);
        boolean bl2 = EObjects.isReadOnly(type);
        if (bl2) {
            type = list.get(1);
            type2 = list.get(0);
        }
        boolean bl3 = !(bl = EObjects.isReadOnly(type));
        boolean bl4 = EObjects.isReadOnly(type2);
        boolean bl5 = !bl4;
        Association association = type.createAssociation(bl ? bl3 : bl5, AggregationKind.NONE_LITERAL, null, 1, 1, type2, bl4 ? bl5 : bl3, AggregationKind.NONE_LITERAL, null, 1, 1);
        EList<Property> eList = association.getMemberEnds();
        Property property = (Property)eList.get(0);
        property.setLowerValue(null);
        property.setUpperValue(null);
        property.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        property.setIsNavigable(bl5);
        Property property2 = (Property)eList.get(1);
        property2.setLowerValue(null);
        property2.setUpperValue(null);
        property2.setVisibility(VisibilityKind.PRIVATE_LITERAL);
        property2.setIsNavigable(bl3);
        if (bl2) {
            eList.move(0, 1);
        }
        return association;
    }
}

